% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{immunity}
\alias{immunity}
\title{Immunity challenges (deprecated)}
\format{
This nested tidy data frame contains the following columns:
\describe{
  \item{\code{season_name}}{The season name}
  \item{\code{season}}{The season number}
  \item{\code{episode}}{Episode number of the immunity challenge was played}
  \item{\code{title}}{Episode title}
  \item{\code{voted_out}}{The castaway voted out}
  \item{\code{day}}{Day the castaway or tribe won the immunity challenge}
  \item{\code{order}}{Order in which the castaway was voted off the island}
  \item{\code{immunity}}{Winners of the immunity challenge. Nested}
}
}
\source{
\url{https://en.wikipedia.org/wiki/Survivor_(American_TV_series)}
}
\usage{
immunity
}
\description{
A dataset containing details on the immunity challenges for each season. This holds the same
information as the challenges dataset. (superseded by the `challenges` dataset)
}
\details{
Contains details on tribal immunity and individual immunity. Currently it does
not include details on hidden immunity idols. This will be added in time.
}
\examples{
library(dplyr)
library(tidyr)
immunity
immunity \%>\%
  unnest(immunity)
}
\keyword{datasets}
