% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{challenge_description}
\alias{challenge_description}
\title{Challenge Description}
\format{
This data frame contains the following columns:
\describe{
  \item{\code{challenge_id}}{Primary key}
  \item{\code{challenge_name}}{The name of the challenge. Challenges can go by different names but where possible
  recurring challenges are kept consistent. While there are tweaks to the challenges where the main components of
  the challenge consistent they share the same name}
  \item{\code{puzzle}}{If the challenge contains a puzzle element}
  \item{\code{race}}{If the challenge is a race between tribes, teams or individuals}
  \item{\code{precision}}{If the challenge contains a precision element e.g. shooting an arrow, hitting a target, etc}
  \item{\code{endurance}}{If the challenge is an endurance event e.g. last tribe, team, individual standing}
  \item{\code{strength}}{If the challenge has a strength based}
  \item{\code{turn_based}}{If the challenge is turn bases i.e. conducted in rounds}
  \item{\code{balance}}{If the challenge contains a balancing element. My refer to the player balancing on something or
  the player balancing an object on something e.g. The Ball Drop}
  \item{\code{food}}{If the challenge contains a food element e.g. the food challenge, biting off chunks of meat}
  \item{\code{knowledge}}{If the challenge contains a knowledge component e.g. Q and A about the location}
  \item{\code{memory}}{If the challenge contains a memory element e.g. memorising a sequence of items}
  \item{\code{fire}}{If the challenge contains an element of fire making / maintaining}
  \item{\code{water}}{If the challenge is held, in part, in the water}
}
}
\source{
\url{https://survivor.fandom.com/wiki/Category:Challenges}
}
\usage{
challenge_description
}
\description{
A dataset detailing the challenges played and the elements they include over all seasons of Survivor
}
\details{
The features of each challenge have been determined largely through string searches of key words or phraces in the
challenge description. It may not capture the full essence of the challenge but on the whole will provide a good basis for
analysis.

Please log any suggested corrections at \url{https://github.com/doehm/survivoR}

For updated data please see the git version.
}
\examples{
library(dplyr)
library(tidyr)
challenge_description
}
\keyword{datasets}
