% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimates.R
\name{vcov.survstan}
\alias{vcov.survstan}
\title{Variance-covariance matrix}
\usage{
\method{vcov}{survstan}(object, all = FALSE, ...)
}
\arguments{
\item{object}{an object of the class survstan.}

\item{all}{logical; if FALSE (default), only covariance matrix associated with regression coefficients is returned; if TRUE, the full covariance matrix is returned.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
the variance-covariance matrix associated with the parameters estimators.
}
\description{
This function extracts and returns the variance-covariance matrix associated with the regression coefficients when the maximum likelihood estimation approach is used in the model fitting.
}
\examples{
\donttest{
library(survstan)
fit <- aftreg(Surv(futime, fustat) ~ ecog.ps + rx, data = ovarian, baseline = "weibull", init = 0)
vcov(fit)
}

}
