\name{svyPVlevel}
\alias{svyPVlevel}

\title{
Proportion in levels estimation
}
\description{
This function categorizes the plausible values into specific user defined levels, to estimate the proportion of population totals within this levels.
}
\usage{
svyPVlevel(by, svydat, pvs, CATDEF,levlab=NA,right=TRUE, colN=FALSE)
}

\arguments{
  \item{by}{
A formula statement is expected which splits the data into several subsets.
}
  \item{svydat}{
A survey design (\code{svydesign} as well as \code{svrepdesign}) which was generated by the \code{survey} package. To figure out how to create a survey design object, please read the help files for the \code{survey} package.
}
  \item{pvs}{
A character vector which includes the colnames of the plausible values. These variables must be part of the survey design comitted as \code{svydat}.
}
  \item{CATDEF}{
A numeric vector which contains the cut points with which the plausible values are categorized. The input follows the same notation as the break argument in the \code{cut} function.
}

  \item{levlab}{
A character vector which contains the levels labels. Default is NA -- which means that the labels will be \code{paste0("level", NUMBEROFLEVELS)}
}

  \item{right}{
Corresponds to the right argument in the \code{cut} function. If TRUE, which is the default, the intervals built by this function are closed on the right.}

  \item{colN}{
If TRUE the colnames will equal the grouping variable names from the by statement. If FALSE, which is the default, the names will be Group1 up to Group k.}

}


\details{

All variables, including the subsetting ones defined with \code{by}, must be part of the survey design object.

Missing values are deleted listwise.

Note that '.' is not allowed as part of the level string of a \code{by} variable. For example c("1.thing","2.thing") is not allowed and will cause a error message. 


}



\value{
The function returns a data.frame with the following columns
\item{Group1..k}{The first k-1 columns show the different levels of the k-1 subsetting groups, provided with \code{by}. The kth group column contains the different levels defined by the \code{CATDEF} vector.}
\item{Number.of.cases}{Shows the unweighted number of cases (NA's excluded) within each group.}
\item{Sum.of.weights}{Shows the sum of weights (NA's excluded) within each group.}
\item{Proportion}{Contains the estimate of the conditional proportion of persons on each level given the categories of the first k-1 groups.}
\item{Proportion.SE}{Contains the SE of the proportion estimate.}
}
\references{
Lumley, T. (2010). \emph{Complex Surveys}. Hoboken, NJ: Wiley.

Saerndal, C.-E. & Swensson, B. & Wretman, J. (1992). \emph{Model Assisted Survey Sampling}. New York: Springer.

Chaudhuri, A. & Stenger, H. (2005). \emph{Survey Sampling. Theory and Methods}. Boka Raton, FL: Chapman & Hall/CRC.
}
\author{
Manuel Reif
}



\seealso{
\code{\link{svyPVbenchmark}}
}
\examples{

data(svy_example1)

erg_l <- svyPVlevel(by = ~ sex, svydat=svy.exrep, 
pvs=c("plaus1","plaus2","plaus3"), CATDEF=c(0,310,322,400))

erg_l


}


\keyword{level}

