% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_results.R
\name{get_cantonalvotes}
\alias{get_cantonalvotes}
\title{Get cantonal results and counting status for selected dates or a given period}
\usage{
get_cantonalvotes(geolevel = "municipality", votedates = NULL,
  from_date = NULL, to_date = NULL)
}
\arguments{
\item{geolevel}{geographical level for which the results should be loaded.  options: "canton", "district" or "municipality"}

\item{votedates}{dates of the ballots to be selected. Default: most recent ballot available. Format = "YYYY-MM-DD"}

\item{from_date}{starting point in time from which vote-results should be retrived. Format = "YYYY-MM-DD"}

\item{to_date}{end point in time to which vote-results should be retrived. Format = "YYYY-MM-DD"}
}
\value{
a tibble containing the results
}
\description{
\code{get_cantonalsvotes} is one of the two main functions of swissvote package. It allows to retrieve the results and the counting status for national ballots.
}
\details{
get_cantonalvotes - retrieve vote results for cantonal ballots at district- or municipality level for selected dates or a given date range.
}
\examples{
 \donttest{
results <-get_cantonalvotes(geolevel="district",from_date = 20180101,to_date=20181231)

 get_cantonalvotes(to_date="1983-12-04")
 
 OR
 
 get_cantonalvotes(votedates="2019-02-10")

glimpse(results)


}

}
