/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import beagleutil.Samples;
import haplotype.SampleHapPairs;
import vcf.GL;
import vcf.Marker;
import vcf.Markers;

public class ImputationGL
implements GL {
    private final Markers refMarkers;
    private final int[] nonRefIndex;
    private final SampleHapPairs haps;

    private static int[] nonRefIndex(Markers markers, Markers markers2) {
        int n = markers.nMarkers();
        int[] nArray = new int[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            nArray[i] = n2 < markers2.nMarkers() && markers.marker(i).equals(markers2.marker(n2)) ? n2++ : -1;
        }
        if (n2 != markers2.nMarkers()) {
            String string = "inconsistent markers";
            throw new IllegalArgumentException(string);
        }
        return nArray;
    }

    public ImputationGL(Markers markers, SampleHapPairs sampleHapPairs) {
        if (markers == null) {
            throw new NullPointerException("refMarkers==null");
        }
        this.refMarkers = markers;
        this.nonRefIndex = ImputationGL.nonRefIndex(markers, sampleHapPairs.markers());
        this.haps = sampleHapPairs;
    }

    @Override
    public boolean isRefData() {
        return this.haps.nMarkers() == this.refMarkers.nMarkers();
    }

    @Override
    public float gl(int n, int n2, byte by, byte by2) {
        int n3 = this.refMarkers.marker(n).nAlleles();
        if (by < 0 || by >= n3) {
            String string = "marker=" + n + " allele1: " + by;
            throw new IllegalArgumentException(string);
        }
        if (by2 < 0 || by2 >= n3) {
            String string = "marker=" + n + " allele2: " + by2;
            throw new IllegalArgumentException(string);
        }
        if (this.nonRefIndex[n] != -1) {
            byte by3 = this.haps.allele1(this.nonRefIndex[n], n2);
            byte by4 = this.haps.allele2(this.nonRefIndex[n], n2);
            return by3 == by && by4 == by2 ? 1.0f : 0.0f;
        }
        return 1.0f;
    }

    @Override
    public byte allele1(int n, int n2) {
        if (this.nonRefIndex[n] != -1) {
            return this.haps.allele1(this.nonRefIndex[n], n2);
        }
        return -1;
    }

    @Override
    public byte allele2(int n, int n2) {
        if (this.nonRefIndex[n] != -1) {
            return this.haps.allele2(this.nonRefIndex[n], n2);
        }
        return -1;
    }

    @Override
    public int nMarkers() {
        return this.refMarkers.nMarkers();
    }

    @Override
    public Marker marker(int n) {
        return this.refMarkers.marker(n);
    }

    @Override
    public Markers markers() {
        return this.refMarkers;
    }

    @Override
    public int nSamples() {
        return this.haps.nSamples();
    }

    @Override
    public Samples samples() {
        return this.haps.samples();
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[ImputationGL: nMarkers=");
        stringBuilder.append(this.nMarkers());
        stringBuilder.append(" nSamples=");
        stringBuilder.append(this.nSamples());
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

