\name{LDDist}
\Rdversion{1.1}
\alias{LDDist}

\title{
LD versus distance Plot
}
\description{
Visualization of pairwise Linkage Disequilibrium (LD) estimates generated by function \code{pairwiseLD} versus marker distance. A single plot is generated for every chromosome.
}
\usage{
LDDist(LDdf,chr=NULL,type="p",breaks=NULL,n=NULL,file=NULL,fileFormat="pdf",onefile=TRUE,colL=2,colD=1,...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{LDdf}{
object of class \code{LDdf} which is the output of function \code{pairwiseLD} and argument \code{type="data.frame"}
}
  \item{chr}{
\code{numeric} scalar or vector. Return value is a plot for each chromosome in \code{chr}. Note: Remember to add in a batch-script one empty line for each chromosome, if you use more than one chromosome!
}  
  \item{type}{
Character string to specify the type of plot. Use \code{"p"} for a scatterplot, \code{"bars"} for stacked bars or \code{"nls"} for scatterplot together with nonlinear regression curve according to Hill and Weir (1988). 
}
  \item{breaks}{
\code{list} containing breaks for stacked bars (optional, only for \code{type="bars"}). Components are \code{dist} with breaks for distance on x-axis and \code{r2} for breaks on for r2 on y-axis. By default, 5 equal spaced categories for dist and r2 are used.  
}
  \item{n}{
\code{numeric}. Number of observations used to estimate LD. Only required for \code{type="nls"}.
}
  \item{file}{
\code{character}. path to a file where plot is saved to (optional).
}
  \item{fileFormat}{
\code{character}. At the moment two file formats are supported: pdf and png. Default is \code{"pdf"}.
}
  \item{onefile}{
\code{logical}. If \code{fileFormat = "pdf"} you can decide, if you like to have all graphics in one file or in multiple files.
}
  \item{colL}{
The color for the line if \code{type="nls"} is used. In other cases without a meaning.
}
  \item{colD}{
The color for the dots in the plot of \code{type="nls"} and \code{type="p"}
}
  \item{\dots}{
Further arguments for \code{plot}
}
}
\references{
For nonlinear regression curve:
Hill WG, Weir BS (1988) Variances and covariances of squared linkage disequilibria in finite populations. Theor Popul Biol 33:54-78.
}
\author{
 Valentin Wimmer, Hans-Juergen Auinger and Theresa Albrecht
}
\seealso{
\code{\link{pairwiseLD}}, \code{\link{LDMap}}
}
\examples{
\dontrun{
# maize data example
data(maize)
maizeC <- codeGeno(maize)

# LD for chr 1
maizeLD <- pairwiseLD(maizeC,chr=1,type="data.frame")
# scatterplot 
LDDist(maizeLD,type="p",pch=19,colD=hsv(alpha=0.1,v=0))

# stacked bars  with default categories
LDDist(maizeLD,type="bars")

# stacked bars  with user-defined categories
LDDist(maizeLD,type="bars",breaks=list(dist=c(0,10,20,40,60,180),
r2=c(1,0.6,0.4,0.3,0.1,0)))
}
}
\keyword{hplot}

