% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plot_synergy.R
\name{PlotSynergy}
\alias{PlotSynergy}
\title{Drug interaction landscape}
\usage{
PlotSynergy(data, type = "2D", save.file = FALSE)
}
\arguments{
\item{data}{a list object generated by function \code{\link{CalculateSynergy}}}

\item{type}{a parameter to specify the type of the interaction landscape, 2D, 3D
or both. By default, 2D interaction landscape is returned.}

\item{save.file}{a logical parameter to specify if the interaction landscape is saved as a pdf file
in the current working directory or returned as an R object. By default, it is FALSE.}
}
\value{
a pdf file or the interaction landscapes are only displayed depending on
the save.file parameter.
}
\description{
A function to visualize the synergy scores for drug combinations as 2D or 3D
interaction landscape over the dose-response matrix.
}
\examples{
data("mathews_screening_data")
data <- ReshapeData(mathews_screening_data)
scores <- CalculateSynergy(data)
PlotSynergy(scores, "all")
}
\author{
Liye He \email{liye.he@helsinki.fi}
}

