% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VERBS-order_by.R
\name{order_by-table.express}
\alias{order_by-table.express}
\alias{order_by}
\alias{order_by.ExprBuilder}
\title{Order by clause}
\usage{
order_by(.data, ...)

\method{order_by}{ExprBuilder}(.data, ..., .collapse,
  .parse = getOption("table.express.parse", FALSE),
  .chain = getOption("table.express.chain", TRUE))
}
\arguments{
\item{.data}{The input data.}

\item{...}{Arguments for the specific methods.}

\item{.collapse}{Ignored. See details.}

\item{.parse}{Logical. Whether to apply \code{\link[rlang:parse_expr]{rlang::parse_expr()}} to obtain the expressions.}

\item{.chain}{Logical. Should a new frame be automatically chained to the expression if the
clause being set already exists?}
}
\description{
Clause for ordering rows.
}
\details{
The \link{ExprBuilder} method dispatches to \link{where-table.express}, but doesn't forward the \code{.collapse}
argument.

To see more examples, check the
\href{https://asardaes.github.io/table.express/articles/table.express.html}{vignette}, or the
\link{table.express-package} entry.
}
\examples{

data("mtcars")

data.table::as.data.table(mtcars) \%>\%
    start_expr \%>\%
    order_by(-cyl, gear)

}
