% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table1.R
\name{render.continuous.default}
\alias{render.continuous.default}
\title{Render continuous values for table output.}
\usage{
render.continuous.default(x, ...)
}
\arguments{
\item{x}{A numeric vector.}

\item{...}{Further arguments, passed to \code{\link{stats.apply.rounding}}.}
}
\value{
A \code{character} vector. Each element is to be displayed in a
separate cell in the table. The \code{\link{names}} of the vector are the
labels to use in the table. However, the first names should be empty as it
will be replaced by the name of the variable. Empty strings are allowed and
result in empty table cells.
}
\description{
Called from \code{\link{table1}} by default to render continuous (i.e.
\code{numeric}) values for displaying in the table.
}
\examples{
x <- exp(rnorm(100, 1, 1))
render.continuous.default(x)

}
\keyword{utilities}
