% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exploratoryUtils.r
\name{XLtwoWay}
\alias{XLtwoWay}
\title{Two-way Contingency Tables exported to a spreadsheet}
\usage{
XLtwoWay(wb, sheet, rowvar, colvar, sumby = 1, rowTitle = "",
  rowNames = NULL, colNames = NULL, ord = NULL, row1 = 1, col1 = 1,
  title = NULL, header = FALSE, purge = FALSE,
  digits = ifelse(length(rowvar) >= 500, 1, 0), useNA = "ifany",
  percents = TRUE, combine = percents)
}
\arguments{
\item{wb}{an \code{\link[XLConnect]{workbook-class}} object}

\item{sheet}{numeric or character: a worksheet name (character) or position (numeric) within \code{wb}.}

\item{rowvar}{vector: categorical variable (logical, numeric, character, factor, etc.) for the table's rows}

\item{colvar}{vector: categorical variable (logical, numeric, character factor, etc.) for the table's columns}

\item{sumby}{whether percentages should be calculated across rows (1, default) or columns (2).}

\item{rowTitle}{character: the title to be placed above the row name column (default empty string)}

\item{rowNames, colNames}{character vector of row and column names. Default behavior (\code{NULL}): automatically determined from data}

\item{ord}{numeric vector specifying row-index order in the produced table. Default (\code{NULL}) is no re-ordering.}

\item{row1, col1}{numeric: the first row and column occupied by the table (title included if relevant).}

\item{title}{character: an optional overall title to the table. Default (\code{NULL}) is no title.}

\item{header}{logical: should a header row with the captions "Counts:" and "Percentages:" be added right above the tables? Relevant only when \code{combine=FALSE,percents=TRUE})}

\item{purge}{logical: should \code{sheet} be created anew, by first removing the previous copy if it exists? (default \code{FALSE})}

\item{digits}{numeric: how many digits (after the decimal point) to show in the percents? Defaults to 1 if n>=500, 0 otherwise.}

\item{useNA}{How to handle missing values. Passed on to \code{\link{table}} (see help on that function for options).}

\item{percents}{logical: would you like only a count table (\code{FALSE}), or also a percents table side-by-side with the the count table (\code{TRUE}, default)?}

\item{combine}{logical: should counts and percents be combined to the popular \code{"Count(percent)"} format, or presented side-by-side in separate tables? (default: same value as \code{percents})}
}
\value{
The function returns invisibly, after writing the data into \code{sheet}.
}
\description{
Produces 2-way contingency tables, optionally with percentages, exports them to a spreadsheet, and saves the file.
}
\details{
This function produces two-way cross-tabulated counts of unique values of \code{rowvar, colvar},
optionally with percentages, calculated either by row (\code{sumby=1}, default) or column (\code{sumby=2}).
Row and column margins are also produced. ##' Tables are automatically saved to the file associated with the \code{wb} spreadsheet object.

There is an underlying asymmetry between rows and columns, because the tables are converted to data frame in order for \code{\link{writeWorksheet}} to export them.
The percents can be in parentheses in the same cells as the counts (\code{combine=TRUE}, default), in an identically-sized table on the side (\code{combine=FALSE,percents=TRUE}), or absent (\code{combine=FALSE,percents=FALSE}). If you want no margins, just use the simpler function \code{\link{XLgeneric}}.
}
\note{
The worksheet \code{sheet} does not have to pre-exist; the function will create it if it doesn't already exist.

By default, if \code{sheet} exists, it will be written into - rather than completely cleared and rewritten de novo. Only existing data in individual cells that are part of the exported tables' target range will be overwritten. If you do want to clear an existing sheet while exporting the new tables, set \code{purge=TRUE}. This behavior, and the usage of \code{purge}, are the same across all \code{table1xls} export functions.

This function uses the internal function \code{fancytab2} which produces 2-way tables with counts, percentages and margins.
}
\examples{

### Contrived example looking at, e.g., the distribution of A-K-Q card counts
### in two partners' Bridge hands


hand1=rhyper(1000,12,40,13)
hand2=rhyper(1000,12-hand1,27+hand1,13)
handNames=c("0-1",2:4,"5 or more")


### The problem is ridiculously symmetric, so I de-symmetrize the presentation slightly:

book3<-XLwriteOpen("hands.xls") 
XLtwoWay(book3,"PartnersAKQcounts",cut(hand1,c(0,2:6,14)-0.5),cut(hand2,c(0,2:5,14)-0.5),
         rowTitle="Hand 1 (rows) vs. Hand 2",rowNames=c(handNames[-5],5,"6 or more","Total"),
         colNames=c(handNames,"Total"),header=TRUE)

## Same table, but percents now condition on columns rather than rows, 
## counts/pct header row removed - but a title added:
XLtwoWay(book3,"PartnersAKQcounts",cut(hand1,c(0,2:6,14)-0.5),cut(hand2,c(0,2:5,14)-0.5),
         rowTitle="Hand 1 (rows) vs. Hand 2",rowNames=c(handNames[-5],5,"6 or more","Total"),
         colNames=c(handNames,"Total"),header=FALSE,row1=12,sumby=2,
         title="Now Percents are Summed by Column:")

cat("Look for",paste(getwd(),"hands.xls",sep='/'),"to see the results!\\n")
}
\author{
Assaf P. Oron \code{<assaf.oron.at.seattlechildrens.org>}
}
\seealso{
Uses \code{\link{writeWorksheet}} to access the spreadsheet. See \code{\link{setStyleAction}} to control the output style. If interested in one-way tables, see \code{\link{XLoneWay}}.
}

