% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fac.tab.R
\name{fac.tab}
\alias{fac.tab}
\title{A Function for Creating  Publication Quality Factor Tables.}
\usage{
fac.tab(x, cut, complexity = TRUE)
}
\arguments{
\item{x}{A psych package object.}

\item{cut}{The value under which all factor loading will be suppressed.}

\item{complexity}{To add complexity parameters.}
}
\value{
A publication ready summary table for the Factor analysis conducted by psych Package. Output structure is data frame.
}
\description{
This function will create publication worthy factor tables from objects created from
psych pack.
I have came across this beautiful piece of codes
at https://www.anthonyschmidt.co/post/2020-09-27-efa-tables-in-r/ and modified it a bit.
}
\examples{
data <- tabledown::Rotter[, 11:31]
correlations <- psych::polychoric(data, correct = 0)
fa.5F.1 <- psych::fa(r=correlations$rho, nfactors = 5, fm= "pa",rotate ="varimax",
residuals = TRUE, SMC = TRUE, n.obs =428)
table <- fac.tab(fa.5F.1, .3)
#always save the output into an object
}
