% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_matrix.R
\name{plot_matrix}
\alias{plot_matrix}
\title{Matrix Plot}
\usage{
plot_matrix(
  object,
  panel,
  diag = TRUE,
  upper = TRUE,
  lower = TRUE,
  freq = FALSE,
  margin = 1,
  scale = TRUE,
  drop_zero = TRUE,
  col = graphics::par("fg"),
  midpoint = NULL,
  axes = TRUE,
  legend = TRUE,
  asp = 1,
  ...
)
}
\arguments{
\item{object}{A \eqn{m \times p}{m x p} \code{numeric} \code{\link{matrix}} or
\code{\link{data.frame}} of count data (absolute frequencies giving the number of
individuals for each category, i.e. a contingency table).}

\item{panel}{A \code{\link{function}} in the form \verb{function(x, y, z, color, ...)}
which gives the action to be carried out in each panel of the display.}

\item{diag}{A \code{\link{logical}} scalar indicating whether the diagonal of the
matrix should be plotted. Only used if \code{object} is a symmetric matrix.}

\item{upper}{A \code{\link{logical}} scalar indicating whether the upper triangle of
the matrix should be plotted. Only used if \code{object} is a symmetric matrix.}

\item{lower}{A \code{\link{logical}} scalar indicating whether the lower triangle of
the matrix should be plotted. Only used if \code{object} is a symmetric matrix.}

\item{freq}{A \code{\link{logical}} scalar indicating whether conditional proportions
given \code{margins} should be used (i.e. entries of \code{object}, divided by the
appropriate marginal sums).}

\item{margin}{An \code{\link{integer}} vector giving the margins to split by:
\code{1} indicates individuals/rows (the default), \code{2} indicates
variables/columns. Only used if \code{freq} is \code{TRUE}.}

\item{scale}{A \code{\link{logical}} scalar indicating whether data should be rescaled
to \eqn{[-1,1]}. Only used if \code{freq} if \code{FALSE}.}

\item{drop_zero}{A \code{\link{logical}} scalar: should zeros be discarded?}

\item{col}{A vector of colors.}

\item{midpoint}{A \code{\link{numeric}} value specifying the data midpoint.}

\item{axes}{A \code{\link{logical}} scalar: should axes be drawn on the plot? It will
omit labels where they would abut or overlap previously drawn labels.}

\item{legend}{A \code{\link{logical}} scalar: should a legend be displayed?}

\item{asp}{A length-one \code{\link{numeric}} vector, giving the aspect ratio
\eqn{y/x}.}

\item{...}{Further arguments to be passed to \code{panel}.}
}
\description{
Matrix Plot
}
\keyword{internal}
