% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tadaa_omnibus.R
\name{tadaa_aov}
\alias{tadaa_aov}
\title{Tadaa, ANOVA!}
\usage{
tadaa_aov(formula, data = NULL, show_effect_size = TRUE,
  show_power = TRUE, factorize = TRUE, type = 3, check_contrasts = TRUE,
  print = c("df", "console", "html", "markdown"))
}
\arguments{
\item{formula}{Formula for model, passed to \code{aov}.}

\item{data}{Data for model.}

\item{show_effect_size}{If \code{TRUE} (default), effect sizes
partial eta^2 and Cohen's f are appended as columns.}

\item{show_power}{(Experimental) If \code{TRUE} (default), power is calculated
via \link[pwr:pwr.f2.test]{pwr::pwr.f2.test} and appended as a column.}

\item{factorize}{If \code{TRUE} (default), non-\code{factor} independent variables
will automatically converted via \code{as.factor}, so beware of your inputs.}

\item{type}{Which type of SS to use. Default is \code{3}, can also be \code{1} or \code{2}.}

\item{check_contrasts}{Only applies to \code{type = 3}. If \code{TRUE} (default),
the \code{contrasts} of each non-ordered \code{factor} are set to \code{"contr.sum"}.}

\item{print}{Print method, default \code{df}: A regular \code{data.frame}.
Otherwise passed to \link[pixiedust:sprinkle_print_method]{pixiedust::sprinkle_print_method} for fancyness.}
}
\value{
A \code{data.frame} by default, otherwise \code{dust} object, depending on \code{print}.
}
\description{
Performs one-, two-way or factorial ANOVA with adjustable sums of squares method and
optionally displays effect sizes ((partial) \eqn{\eta^2}, Cohen's f) and
power (calculated via \link[pwr:pwr.f2.test]{pwr::pwr.f2.test} to work with unbalanced designs).
}
\details{
If a specified independent variable is not properly encoded as a \code{factor}, it is
automatically converted if \code{factorize = TRUE} to ensure valid results.

If \code{type = 3} and \code{check_contrasts = TRUE}, the \code{"contrasts"} of
each non-ordered factor will be checked and set to \code{contr.sum} to ensure the function
yields usable results. It is highly recommended to only use \code{check_contrasts = FALSE}
for debugging or educational purposes, or of you know what you're doing and using
your own contrast matrix.
}
\examples{
tadaa_aov(stunzahl ~ jahrgang, data = ngo)
tadaa_aov(stunzahl ~ jahrgang * geschl, data = ngo)

# Other types of sums and print options
\dontrun{
tadaa_aov(stunzahl ~ jahrgang * geschl, data = ngo, type = 1, print = "console")
tadaa_aov(stunzahl ~ jahrgang * geschl, data = ngo, type = 3, print = "console")
tadaa_aov(stunzahl ~ jahrgang * geschl, data = ngo,
          type = 3, check_contrasts = FALSE, print = "console")
}
}
\seealso{
Other Tadaa-functions: \code{\link{tadaa_chisq}},
  \code{\link{tadaa_kruskal}}, \code{\link{tadaa_levene}},
  \code{\link{tadaa_nom}}, \code{\link{tadaa_normtest}},
  \code{\link{tadaa_one_sample}}, \code{\link{tadaa_ord}},
  \code{\link{tadaa_pairwise_gh}},
  \code{\link{tadaa_pairwise_tukey}},
  \code{\link{tadaa_pairwise_t}},
  \code{\link{tadaa_t.test}}, \code{\link{tadaa_wilcoxon}}
}
