% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recode_helpers.R
\name{generate_recodes}
\alias{generate_recodes}
\title{Convenience functions for interval recodes}
\usage{
generate_recodes(from, to, width = 5)
}
\arguments{
\item{from, to}{A \verb{numeric value} for the beginning and the end of the interval.}

\item{width}{The width of the interval, e.g. 5 (default) for intervals 0-5.}
}
\value{
A \code{character} vector of recode assignments compatible with \link[car:recode]{car::recode}.
}
\description{
Get recode assigments for even intervals of discrete numeric values compatible
with \link[car:recode]{car::recode}.
}
\examples{
\dontrun{
x <- round(runif(100, 0, 100), 0)
recodes <- generate_recodes(0, 100, 10)

library(car)
recode(x, recodes = recodes)
}
}
