% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/t_test.R
\name{tadaa_t.test}
\alias{tadaa_t.test}
\title{Tadaa, t-Test!}
\usage{
tadaa_t.test(data, response, group, direction = "two.sided", paired = FALSE,
  na.rm = TRUE, print = "console")
}
\arguments{
\item{data}{A \code{data.frame}.}

\item{response}{The response variable (dependent).}

\item{group}{The group variable, usually a \code{factor}.}

\item{direction}{Test direction, like \code{alternative} in \link{t.test}.}

\item{paired}{If \code{TRUE}, a paired t.test is performed with approproate power calculation.}

\item{na.rm}{If \code{TRUE} (default), missing values are dropped.}

\item{print}{Print method. Passed to \link[pixiedust]{sprinkle_print_method} as of now.}
}
\value{
A \code{data.frame}, optionally markdown'd
}
\description{
Tadaa, t-Test!
}
\examples{
df <- data.frame(x = runif(100), y = sample(c("A", "B"), 100, TRUE))
tadaa_t.test(df, x, y)

df <- data.frame(x = runif(100), y = c(rep("A", 50), rep("B", 50)))
tadaa_t.test(df, x, y, paired = TRUE)
}
\seealso{
Other Tadaa.functions: \code{\link{tadaa_aov}},
  \code{\link{tadaa_int}}, \code{\link{tadaa_nom}},
  \code{\link{tadaa_ord}}
}

