% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_builder.R
\name{add_col}
\alias{add_col}
\title{Add columns}
\usage{
add_col(table_builder, ..., subrow = NA, subcol = NA)
}
\arguments{
\item{table_builder}{The table builder to work on}

\item{...}{elements to add columnwise}

\item{subrow}{optional additional specifier for sub element of AST row for traceabililty}

\item{subcol}{optional additional specifier for sub element of AST col for traceabililty}
}
\value{
a table builder with the cursor at the column past the last addition
}
\description{
Add all elements specified and advance to the next column after each addition
}
\examples{
library(magrittr)
x <- Parser$new()$run(y ~ x)
new_table_builder(x$right, x$left) \%>\%
add_col(tg_N(1:3))
}
