% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render-latex.R
\name{latex}
\alias{latex}
\alias{latex.default}
\alias{latex.cell}
\alias{latex.cell_label}
\alias{latex.logical}
\alias{latex.cell_header}
\alias{latex.cell_subheader}
\alias{latex.tangram}
\title{Render to LaTeX methods for tangram cell objects}
\usage{
latex(object, ...)

\method{latex}{default}(object, ...)

\method{latex}{cell}(object, na.blank = TRUE, ...)

\method{latex}{cell_label}(object, ...)

\method{latex}{logical}(object, ...)

\method{latex}{cell_header}(object, ...)

\method{latex}{cell_subheader}(object, ...)

\method{latex}{tangram}(object, fragment = TRUE, filename = NULL, append = FALSE, ...)
}
\arguments{
\item{object}{object; the item to render to latex}

\item{...}{additional arguments}

\item{na.blank}{logical; Dispaly NAs as blanks.}

\item{fragment}{logical; Is this a complete LaTeX document or just the table fragment}

\item{filename}{character; filename to write LaTex into}

\item{append}{logical; Should the write be an append operation or overwrite}
}
\value{
the LaTeX rendering
}
\description{
Each of these methods will render the cell object as a LaTeX fragment
}
\details{
There are addition arguments possible to control the rendering, but
due to some oddities between CRAN requirements and how R handles defaults
(for full details see the source code)
they are as follows

* cgroup.just character; The text of the column justification used in the table

* arraystretch numeric; The arraystretch parameter used for vertical spacing

* style character; can be null or "nejm" for different table styling

* pct_width numeric; a scaling to be applied to the entire table

* placement character; placement directive, defaults to "H"
}
\examples{
\dontrun{
latex(cell_label("123"))
latex(hmisc_iqr(rnorm(20)))
latex(hmisc_fraction(45, 137))
tbl <- tangram(drug~bili, pbc, "tbl")
latex(tbl)
}
}
