% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ode.R
\name{specify_ode}
\alias{specify_ode}
\title{Specify Ordinary Differential Equation (ODE)}
\usage{
specify_ode(code, fname = NULL, pname = c("dy", "x", "y", "p"))
}
\arguments{
\item{code}{string with the body of the function definition (see details)}

\item{fname}{Optional name of the exported C++ function}

\item{pname}{Vector of variable names (results, inputs, states, parameters)}
}
\value{
pointer (externalptr) to C++ function
}
\description{
Define compiled code for ordinary differential equation.
}
\details{
The model (\code{code}) should be specified as the body of of C++ function.
The following variables are defined bye default
(see the argument \code{pname})
\describe{
\item{dy}{Vector with derivatives, i.e. the rhs of the ODE (the result).}
\item{x}{Vector with the first element being the time, and the following
elements additional exogenous input variables,}
\item{y}{Vector with the dependent variable}
\item{p}{Parameter vector}
}
\eqn{y'(t) = f_{p}(x(t), y(t))}
All variables are treated as Armadillo (http://arma.sourceforge.net/)
vectors/matrices.

As an example consider the \emph{Lorenz Equations}
\eqn{\frac{dx_{t}}{dt} = \sigma(y_{t}-x_{t})}
\eqn{\frac{dy_{t}}{dt} = x_{t}(\rho-z_{t})-y_{t}}
\eqn{\frac{dz_{t}}{dt} = x_{t}y_{t}-\beta z_{t}}

We can specify this model as
\code{ode <- 'dy(0) = p(0)*(y(1)-y(0));
      dy(1) = y(0)*(p(1)-y(2));
      dy(2) = y(0)*y(1)-p(2)*y(2);'}
\code{dy <- specify_ode(ode)}

As an example of model with exogenous inputs consider the following ODE:
\eqn{y'(t) = \beta_{0} + \beta_{1}y(t) +
\beta_{2}y(t)x(t) + \beta_{3}x(t)\cdot t}
This could be specified as
\code{mod <- 'double t = x(0);
              dy = p(0) + p(1)*y + p(2)*x(1)*y + p(3)*x(1)*t;'}
\code{dy <- specify_ode(mod)}
}
\examples{
ode <- paste0(
  "dy(0) = p(0)*(y(1)-y(0));",
  "dy(1) = y(0)*(p(1)-y(2));",
  "dy(2) = y(0)*y(1)-p(2)*y(2);", collapse="\n"
)
\donttest{ # Reduce test time
dy <- specify_ode(ode)
tt <- seq(0, 100, length.out=2e4)
yy <- solve_ode(dy, input=tt, init=c(1, 1, 1), par=c(10, 28, 8/3))
}
}
\seealso{
solve_ode
}
\author{
Klaus Kähler Holst
}
