% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/synonyms.R
\name{synonyms}
\alias{synonyms}
\alias{synonyms.default}
\alias{synonyms.ids}
\alias{synonyms.nbnid}
\alias{synonyms.tpsid}
\alias{synonyms.tsn}
\alias{synonyms.ubioid}
\title{Retrieve synonyms from various sources given input taxonomic names or identifiers.}
\usage{
synonyms(...)

\method{synonyms}{default}(x, db = NULL, ...)

\method{synonyms}{tsn}(id, ...)

\method{synonyms}{tpsid}(id, ...)

\method{synonyms}{ubioid}(id, ...)

\method{synonyms}{nbnid}(id, ...)

\method{synonyms}{ids}(id, ...)
}
\arguments{
\item{...}{Other passed arguments.}

\item{x}{character; taxons to query.}

\item{db}{character; database to query. either \code{itis}, \code{tropicos},
\code{ubio}, or \code{nbn}.}

\item{id}{character; identifiers, returned by \code{\link[taxize]{get_tsn}},
\code{\link[taxize]{get_tpsid}}, \code{\link[taxize]{get_ubioid}}, or
\code{\link[taxize]{get_nbnid}}}
}
\value{
A named list of data.frames with the synonyms of every supplied taxa.
}
\description{
Retrieve synonyms from various sources given input taxonomic names or identifiers.
}
\note{
If IDs are supplied directly (not from the \code{get_*} functions) you
   must specify the type of ID.
}
\examples{
\dontrun{
# Plug in taxon names directly
synonyms("Poa annua", db="itis")
synonyms(c("Poa annua",'Pinus contorta','Puma concolor'), db="itis")
synonyms("Poa annua", db="tropicos")
synonyms("Pinus contorta", db="tropicos")
synonyms(c("Poa annua",'Pinus contorta'), db="tropicos")
synonyms("Salmo friderici", db='ubio')
synonyms(c("Salmo friderici",'Carcharodon carcharias','Puma concolor'), db="ubio")
synonyms("Pinus sylvestris", db='nbn')

# Use get_* methods
synonyms(get_tsn("Poa annua"))
synonyms(get_tpsid("Poa annua"))
synonyms(get_ubioid("Carcharodon carcharias"))
synonyms(get_nbnid("Carcharodon carcharias"))

# Pass many ids from class "ids"
out <- get_ids(names="Poa annua", db = c('itis','tropicos'))
synonyms(out)
}
}
\seealso{
\code{\link[taxize]{get_tsn}}, \code{\link[taxize]{get_tpsid}},
\code{\link[taxize]{get_ubioid}}, \code{\link[taxize]{get_nbnid}}
}

