% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.R
\name{as.list}
\alias{as.list}
\alias{S4_to_list}
\alias{as.list,taxlist-method}
\alias{as<-}
\alias{as<-,taxlist-method}
\title{Coerce taxlist objects to lists.}
\usage{
S4_to_list(x)

\S4method{as.list}{taxlist}(x, ...)

as(from) <- value

\S4method{as}{taxlist}(from) <- value
}
\arguments{
\item{x}{An object of class \linkS4class{taxlist} or any S4 class.}

\item{...}{further arguments passed to or from other methods.}

\item{from}{An object of class \linkS4class{taxlist}, which will be coerced by
the replacement method.}

\item{value}{A character value indicating the class to be coerced to. Here
it is always \code{"list"}.}
}
\value{
An object of class \link{list}.
}
\description{
Coercion of S4 objects to lists can be applied to explore their content,
avoiding errors caused by their validation.
}
\details{
Coerce \linkS4class{taxlist} objects to lists.
}
\examples{
Easplist <- as.list(Easplist)
class(Easplist)

}
\author{
Miguel Alvarez \email{kamapu78@gmail.com}
}
