% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_methods.R
\name{fuzzy_search}
\alias{fuzzy_search}
\title{Match misspelled or partial scientific names}
\usage{
fuzzy_search(
  x,
  term,
  sensitivity = 0,
  allow_term_removal = FALSE,
  force_binomial = FALSE
)
}
\arguments{
\item{x}{A tibble created with \code{load_taxonomies()} or \code{load_population()} or \code{load_sample()}.}

\item{term}{A string consisting of a scientific name.}

\item{sensitivity}{An integer representing character mismatch tolerance. Defaults to intolerant i.e. sensitivity=0.}

\item{allow_term_removal}{A logical indicating whether searches against only the first word of \code{term}
should be carried out if no matches are found. Defaults to FALSE.}

\item{force_binomial}{A logical indicating whether \code{term} should be stripped
to a maximum of two words. Defaults to FALSE.}
}
\value{
A list of candidate match(es), if applicable.
}
\description{
Match misspelled or partial scientific names
}
\details{
The \code{sensitivity} parameter sets the number of character mismatches that are tolerated for
a match to be reported. The higher the sensitivity, the more matches will be found, but the
less relevant they may be. The \code{allow_term_removal} parameter allows stripping the search query
to only retain the characters before the first occurrence of a white space i.e. only the first
word of a search query is used during the search. This is useful when "Genus sp." or "Genus indet." is
the search query. However, \code{fuzzy_search()} will always search using the entire search query first and
then only proceed to strip terms if no hits are found. On the other hand, if \code{force_binomial} is set to TRUE,
the search query will first be limited to the first two words before searching commences. This in turn is useful
if the search query includes credit to the publisher e.g. "Birgus latro (Linnaeus, 1767)" or to
prevent subspecies names (so-called trinomials) from leading to a match not being made.
}
\examples{
fuzzy_search(load_sample(), "Miacis deutschi")
fuzzy_search(load_sample(), "Miacis sp.", allow_term_removal = TRUE)
fuzzy_search(load_sample(), "Miacus deutschi", sensitivity = 1)
fuzzy_search(load_sample(), "Miacis deutschi (Smith, 2022)", force_binomial = TRUE)
}
