% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxo2syn.R
\name{taxo2syn}
\alias{taxo2syn}
\title{Taxolist to Synonym list}
\usage{
taxo2syn(
  taxolist,
  canonical = "canonical",
  synonym = "synonym",
  duplicate = FALSE,
  sepchar = ","
)
}
\arguments{
\item{taxolist}{taxolist}

\item{canonical}{names column name, Default: 'canonical'}

\item{synonym}{Synonym column name to be created, Default: 'synonym'}

\item{duplicate}{If true, duplicate entries are allowed in secondary field}

\item{sepchar}{Character separator between the data items. Default is comma}
}
\value{
returns a synonym list  all the names in same column and
accepted names linked to synonyms with id and accid fields
}
\description{
Converts a taxolist to Synonym list with Accepted Names and 
 Synonym columns format
}
\details{
Converts a taxolist to synonyms list
}
\examples{
\donttest{
mytaxo <- data.frame("id" = c(1,2,3,4,5,6,7),
                    "canonical" = c("Hypochlorosis ancharia",
                                    "Hypochlorosis tenebrosa",
                                    "Pseudonotis humboldti",
                                    "Myrina ancharia",
                                    "Hypochlorosis ancharia tenebrosa",
                                    "Hypochlorosis ancharia obiana",
                                    "Hypochlorosis lorquinii"),
                     "family" = c("Lycaenidae", "Lycaenidae", "Lycaenidae",
                                  "Lycaenidae", "Lycaenidae", "Lycaenidae",
                                  "Lycaenidae"),
                    "accid" = c(0,1,1,1,0,0,0),
                    "source" = c("itis","itis","wiki","wiki","itis",
                                 "itis","itis"),
                    stringsAsFactors = FALSE)
mysynlst <- taxo2syn(mytaxo)
}
}
\seealso{
Other List functions: 
\code{\link{DwC2taxo}()},
\code{\link{cast_cs_field}()},
\code{\link{compact_ids}()},
\code{\link{get_synonyms}()},
\code{\link{match_lists}()},
\code{\link{melt_cs_field}()},
\code{\link{merge_lists}()},
\code{\link{syn2taxo}()},
\code{\link{synonymize_subspecies}()},
\code{\link{taxo2DwC}()},
\code{\link{taxo2doc}()},
\code{\link{wiki2taxo}()}
}
\concept{List functions}
