% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bind_rows.R
\name{bind_rows_data}
\alias{bind_rows_data}
\title{Bind rows}
\usage{
bind_rows_data(..., fill = FALSE)
}
\arguments{
\item{...}{Input data frames or list of data frames}

\item{fill}{Logical indicating whether to fill missing columns in data frames
with missing values.}
}
\value{
The list collapsed into a single data frame
}
\description{
Convenient wrapper around \code{\link[base]{do.call}("rbind", ...)} that
(a) sets the 'quote' argument to TRUE and (b) fills data frames with missing
columns with NAs of the appropriate class.
}
\examples{

## list of data frames with inconsistent columns
x <- as_tbl_data(mtcars[1:3, ])
xx <- x
xx$y <- "a"
l <- list(x, xx, mtcars)

## bind rows and fill missing columns with NAs
bind_rows_data(l, fill = TRUE)

}
