% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tclustIC.R
\name{plot.tclustIC}
\alias{plot.tclustIC}
\title{The \code{plot} method for objects of class \code{tclustIC}}
\usage{
\method{plot}{tclustIC}(x, whichIC, main, xlab, ylab, xlim, ylim, col, lty, ...)
}
\arguments{
\item{x}{The \code{tclustIC} object to be shown}

\item{whichIC}{A string indicating which information criterion will be used. See the details section for more information.}

\item{main}{A character-string containing the title of the plot.}

\item{xlab, ylab, xlim, ylim}{Arguments passed to plot().}

\item{col}{A single value or vector of line colors passed to \code{\link[graphics]{lines}}.}

\item{lty}{A single value or vector of line types passed to \code{\link[graphics]{lines}}.}

\item{\ldots}{Arguments to be passed to or from other methods.}
}
\description{
The \code{plot} method for class \code{tclustIC}: This function implements 
 a series of plots, which display characteristic values 
 of each model, computed with different values for \code{k} and \code{c} for a fixed \code{alpha}.
}
\examples{

 \donttest{
 sig <- diag (2)
 cen <- rep (1, 2)
 x <- rbind(MASS::mvrnorm(108, cen * 0,   sig),
 	       MASS::mvrnorm(162, cen * 5,   sig * 6 - 2),
 	       MASS::mvrnorm(30, cen * 2.5, sig * 50))

 (out <- tclustIC(x, whichIC="ALL"))

 plot(out)
 }

}
\references{
Cerioli, A., Garcia-Escudero, L.A., Mayo-Iscar, A. and Riani M. (2017).
     Finding the Number of Groups in Model-Based Clustering via Constrained Likelihoods,
     \emph{Journal of Computational and Graphical Statistics}, pp. 404-416,
     https://doi.org/10.1080/10618600.2017.1390469.
}
