% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getOrders.R
\name{getOrders}
\alias{getOrders}
\title{Download all orders in account}
\usage{
getOrders(
  token = "",
  live = FALSE,
  only_live_orders = TRUE,
  raw_orders = FALSE,
  from = Sys.Date() - 5,
  to = Sys.Date(),
  time_transform = TRUE
)
}
\arguments{
\item{token}{token from Tinkoff account}

\item{live}{live trading - TRUE or sandbox (paper) trading - FALSE (default)}

\item{only_live_orders}{select only live order or use history? (default TRUE)}

\item{raw_orders}{get raw orders from server or use transformation? (default FALSE)}

\item{from}{depth of trading history (from)}

\item{to}{depth of trading history (to)}

\item{time_transform}{trasform time from string to POSIXct}
}
\value{
returns an data.table object containing the requested data with orders of current account.
}
\description{
Makes a request to the server, and returns a data.table object with information about all live orders related with your account if successful.
}
\details{
As described by the official Tinkoff Investments documentation
}
\note{
Not for the faint of heart. All profits and losses related are yours and yours alone. If you don't like it, write it yourself.
}
\examples{
live = FALSE
token = 'your_sandbox_token_from_tcs_account'
getOrders(token,live)
}
\seealso{
\code{\link{getTrades}} \code{\link{cancelOrder}}
}
\author{
Vyacheslav Arbuzov
}
