% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getTrades.R
\name{getTrades}
\alias{getTrades}
\title{Download trades of current account}
\usage{
getTrades(
  token = "",
  live = FALSE,
  from = Sys.Date() - 5,
  to = Sys.Date(),
  symbol_info = FALSE,
  time_transform = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{token}{token from Tinkoff account}

\item{live}{live trading - TRUE or sandbox (paper) trading - FALSE (default)}

\item{from}{from what date download trades}

\item{to}{to what date download trades}

\item{symbol_info}{download full information about instruments of trades (4 additional requests)}

\item{time_transform}{trasform time from string to POSIXct}

\item{verbose}{display status of retrieval (default FALSE)}
}
\value{
returns an data.table object containing the requested data with trades of current account.
}
\description{
Makes a request to the server, and returns an data.table object with information about account trades if successful.
}
\details{
parsing this data from getOperaions function
}
\note{
Not for the faint of heart. All profits and losses related are yours and yours alone. If you don't like it, write it yourself.
}
\examples{
live = FALSE
token = 'your_sandbox_token_from_tcs_account'
getTrades(token,live)
}
\seealso{
\code{\link{getOrders}}
}
\author{
Vyacheslav Arbuzov
}
