% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tm_t_events_summary.R
\name{tm_t_events_summary}
\alias{tm_t_events_summary}
\title{teal Module: Adverse Events Summary}
\usage{
tm_t_events_summary(
  label,
  dataname,
  parentname = ifelse(inherits(arm_var, "data_extract_spec"),
    teal.transform::datanames_input(arm_var), "ADSL"),
  arm_var,
  flag_var_anl = NULL,
  flag_var_aesi = NULL,
  dthfl_var =
    teal.transform::choices_selected(teal.transform::variable_choices(parentname,
    "DTHFL"), "DTHFL", fixed = TRUE),
  dcsreas_var =
    teal.transform::choices_selected(teal.transform::variable_choices(parentname,
    "DCSREAS"), "DCSREAS", fixed = TRUE),
  llt = teal.transform::choices_selected(teal.transform::variable_choices(dataname,
    "AEDECOD"), "AEDECOD", fixed = TRUE),
  aeseq_var = teal.transform::choices_selected(teal.transform::variable_choices(dataname,
    "AESEQ"), "AESEQ", fixed = TRUE),
  add_total = TRUE,
  total_label = default_total_label(),
  na_level = default_na_str(),
  count_subj = TRUE,
  count_pt = TRUE,
  count_events = TRUE,
  pre_output = NULL,
  post_output = NULL,
  basic_table_args = teal.widgets::basic_table_args()
)
}
\arguments{
\item{label}{(\code{character})\cr menu item label of the module in the teal app.}

\item{dataname}{(\code{character})\cr analysis data used in teal module.}

\item{parentname}{(\code{character})\cr parent analysis data used in teal module, usually this refers to \code{ADSL}.}

\item{arm_var}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object with all
available choices and preselected option for variable names that can be used as \code{arm_var}.
It defines the grouping variable(s) in the results table.
If there are two elements selected for \code{arm_var},
second variable will be nested under the first variable.}

\item{flag_var_anl}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}} or \code{NULL})\cr
vector with names of flag variables from \code{dataset} used to count adverse event sub-groups (e.g. Serious events,
Related events, etc.). Variable labels are used as table row names if they exist.}

\item{flag_var_aesi}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}} or \code{NULL})\cr
vector with names of flag variables from \code{dataset} used to count adverse event special interest groups. All flag
variables must be of type \code{logical}. Variable labels are used as table row names if they exist.}

\item{dthfl_var}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object
with all available choices and preselected option for variable names that can be used as death flag variable.
Records with `"Y"`` are summarized in the table row for "Total number of deaths".}

\item{dcsreas_var}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object
with all available choices and preselected option for variable names that can be used as study discontinuation
reason variable. Records with \code{"ADVERSE EVENTS"} are summarized in the table row for
"Total number of patients withdrawn from study due to an AE".}

\item{llt}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr name of the variable
with low level term for events.}

\item{aeseq_var}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr variable for
adverse events sequence number from \code{dataset}. Used for counting total number of events.}

\item{add_total}{(\code{logical})\cr whether to include column with total number of patients.}

\item{total_label}{(\code{string})\cr string to display as total column/row label if column/row is
enabled (see \code{add_total}). Defaults to \code{"All Patients"}. To set a new default \code{total_label} to
apply in all modules, run \code{set_default_total_label("new_default")}.}

\item{na_level}{(\code{string})\cr used to replace all \code{NA} or empty values
in character or factor variables in the data. Defaults to \code{"<Missing>"}. To set a
default \code{na_level} to apply in all modules, run \code{set_default_na_str("new_default")}.}

\item{count_subj}{(\code{logical})\cr whether to show count of unique subjects (based on \code{USUBJID}). Only applies if
event flag variables are provided.}

\item{count_pt}{(\code{logical})\cr whether to show count of unique preferred terms (based on \code{llt}). Only applies if
event flag variables are provided.}

\item{count_events}{(\code{logical})\cr whether to show count of events (based on \code{aeseq_var}). Only applies if event
flag variables are provided.}

\item{pre_output}{(\code{shiny.tag}) optional,\cr with text placed before the output to put the output into context.
For example a title.}

\item{post_output}{(\code{shiny.tag}) optional,\cr with text placed after the output to put the output into context.
For example the \code{\link[shiny:helpText]{shiny::helpText()}} elements are useful.}

\item{basic_table_args}{(\code{basic_table_args}) optional\cr object created by \code{\link[teal.widgets:basic_table_args]{teal.widgets::basic_table_args()}}
with settings for the module table. The argument is merged with option \code{teal.basic_table_args} and with default
module arguments (hard coded in the module body).
For more details, see the vignette: \code{vignette("custom-basic-table-arguments", package = "teal.widgets")}.}
}
\value{
a \code{teal_module} object.
}
\description{
This module produces an adverse events summary table.
}
\examples{
library(dplyr)

data <- teal_data()
data <- within(data, {
  ADSL <- tmc_ex_adsl \%>\%
    mutate(
      DTHFL = case_when(
        !is.na(DTHDT) ~ "Y",
        TRUE ~ ""
      ) \%>\% with_label("Subject Death Flag")
    )
  ADAE <- tmc_ex_adae

  add_event_flags <- function(dat) {
    dat <- dat \%>\%
      mutate(
        TMPFL_SER = AESER == "Y",
        TMPFL_REL = AEREL == "Y",
        TMPFL_GR5 = AETOXGR == "5",
        TMP_SMQ01 = !is.na(SMQ01NAM),
        TMP_SMQ02 = !is.na(SMQ02NAM),
        TMP_CQ01 = !is.na(CQ01NAM)
      )
    column_labels <- list(
      TMPFL_SER = "Serious AE",
      TMPFL_REL = "Related AE",
      TMPFL_GR5 = "Grade 5 AE",
      TMP_SMQ01 = aesi_label(dat[["SMQ01NAM"]], dat[["SMQ01SC"]]),
      TMP_SMQ02 = aesi_label("Y.9.9.9.9/Z.9.9.9.9 AESI"),
      TMP_CQ01 = aesi_label(dat[["CQ01NAM"]])
    )
    col_labels(dat)[names(column_labels)] <- as.character(column_labels)
    dat
  }

  #' Generating user-defined event flags.
  ADAE <- ADAE \%>\% add_event_flags()

  ae_anl_vars <- names(ADAE)[startsWith(names(ADAE), "TMPFL_")]
  aesi_vars <- names(ADAE)[startsWith(names(ADAE), "TMP_")]
})

datanames <- c("ADSL", "ADAE")
datanames(data) <- datanames
join_keys(data) <- default_cdisc_join_keys[datanames]

app <- init(
  data = data,
  modules = modules(
    tm_t_events_summary(
      label = "Adverse Events Summary",
      dataname = "ADAE",
      arm_var = choices_selected(
        choices = variable_choices("ADSL", c("ARM", "ARMCD")),
        selected = "ARM"
      ),
      flag_var_anl = choices_selected(
        choices = variable_choices("ADAE", data[["ae_anl_vars"]]),
        selected = data[["ae_anl_vars"]][1],
        keep_order = TRUE,
        fixed = FALSE
      ),
      flag_var_aesi = choices_selected(
        choices = variable_choices("ADAE", data[["aesi_vars"]]),
        selected = data[["aesi_vars"]][1],
        keep_order = TRUE,
        fixed = FALSE
      ),
      add_total = TRUE
    )
  )
)
if (interactive()) {
  shinyApp(app$ui, app$server)
}

}
\seealso{
The \href{https://insightsengineering.github.io/tlg-catalog/stable/}{TLG Catalog} where additional example
apps implementing this module can be found.
}
