% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AddCardModule.R
\name{add_card_button_srv}
\alias{add_card_button_srv}
\title{Add Card Button Server}
\usage{
add_card_button_srv(id, reporter, card_fun)
}
\arguments{
\item{id}{\code{character(1)} this \code{shiny} module's id.}

\item{reporter}{\code{\link{Reporter}} instance.}

\item{card_fun}{\code{function} which returns a \code{\link{ReportCard}} instance,
the function has optional \code{card} and  \code{comment} arguments.
If the \code{card} argument is added then the \code{ReportCard} instance is automatically created for the user.
If the \code{comment} argument is not specified then it is added automatically at the end of the Card.
The card name set by default in \code{card_fun} will be overcome by the \code{label} input which will be set automatically
when adding a card.}
}
\value{
\code{shiny::moduleServer}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
server for adding views/cards to the Report.

For more details see the vignette: \code{vignette("simpleReporter", "teal.reporter")}.
}
\details{
This module allows using a child of \code{\link{ReportCard}} instead of \code{\link{ReportCard}}.
To properly support this, an instance of the child class must be passed
as the default value of the \code{card} argument in the \code{card_fun} function.
See below:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{CustomReportCard <- R6::R6Class( # nolint: object_name_linter.
  classname = "CustomReportCard",
  inherit = teal.reporter::ReportCard
)

custom_function <- function(card = CustomReportCard$new()) \{
  card
\}
}\if{html}{\out{</div>}}
}
