% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/module_bookmark_manager.R
\name{bookmarks_identical}
\alias{bookmarks_identical}
\title{Compare bookmarks.}
\usage{
bookmarks_identical(book1, book2)
}
\arguments{
\item{book1, book2}{bookmark directories stored in \verb{shiny_bookmarks/};
default to the two most recently modified directories}
}
\value{
Invisible \code{NULL} if bookmarks are identical or if there are no bookmarks to test.
\code{FALSE} if inconsistencies are detected.
}
\description{
Test if two bookmarks store identical state.
}
\details{
\code{input} environments are compared one variable at a time and if not identical,
values in both bookmarks are reported. States of \code{datatable}s are stripped
of the \code{time} element before comparing because the time stamp is always different.
The contents themselves are not printed as they are large and the contents are not informative.
Elements present in one bookmark and absent in the other are also reported.
Differences are printed as messages.

\code{values} environments are compared with \code{all.equal}.
}
\section{How to use}{

Open an application, change relevant inputs (typically, all of them), and create a bookmark.
Then open that bookmark and immediately create a bookmark of that.
If restoring bookmarks occurred properly, the two bookmarks should store the same state.
}

\keyword{internal}
