% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/teal_modifiers.R
\name{teal_modifiers}
\alias{teal_modifiers}
\alias{modify_title}
\alias{modify_header}
\alias{modify_footer}
\title{Replace UI Elements in \code{teal} UI objects}
\usage{
modify_title(x, title = "teal app", favicon = NULL)

modify_header(x, element = tags$p())

modify_footer(x, element = tags$p())
}
\arguments{
\item{x}{(\code{teal_app}) A \code{teal_app} object created using the \code{init} function.}

\item{title}{(\code{shiny.tag} or \code{character(1)}) The new title to be used.}

\item{favicon}{(\code{character}) The path for the icon for the title.
The image/icon path can be remote or the static path accessible by \code{shiny}, like the \verb{www/}.
If the favicon is \code{NULL} the \code{teal} logo will be used as the favicon.}

\item{element}{Replacement UI element (shiny tag or HTML)}
}
\description{
Replace UI Elements in \code{teal} UI objects
}
\examples{
app <- init(
  data = teal_data(IRIS = iris, MTCARS = mtcars),
  modules = modules(example_module())
) |>
  modify_title(title = "Custom title")

if (interactive()) {
  shinyApp(app$ui, app$server)
}
app <- init(
  data = teal_data(IRIS = iris),
  modules = modules(example_module())
) |>
  modify_header(element = tags$div(h3("Custom header")))

if (interactive()) {
  shinyApp(app$ui, app$server)
}
app <- init(
  data = teal_data(IRIS = iris),
  modules = modules(example_module())
) |>
  modify_footer(element = "Custom footer")

if (interactive()) {
  shinyApp(app$ui, app$server)
}
}
\keyword{internal}
\section{Examples in Shinylive}{
\describe{
  \item{example-1}{
    \href{https://shinylive.io/r/app/#code=NobwRAdghgtgpmAXGKAHVA6ASmANGAYwHsIAXOMpMAGwEsAjAJykYE8AKcqagSgB0ItMnGYFStAG5wABAB4AtNIBmAVwhjaJdj2kAVLAFUAogIFpUcxUNql2A6dIAmUUlGkBeaV2oB9Z6-YASSxAgGUPaVpGWgBnXGkAWV0AYQBBLHDPGFICFhieXHtpGCJHFWo4GIiSsoqY9jgAD1hUCp8a8rhtfggdAB8APiKa2iVWH3FSCs4bCoi+MGSVGNIiGC9ZuAWegVHpdiFyUXEpbukQIpiACyFWVPR2cwASFVp455iRKUYegF8wX4AXSAA}{Open in Shinylive}
    \if{html}{\out{<iframe class="iframe_shinylive" src="https://shinylive.io/r/app/#code=NobwRAdghgtgpmAXGKAHVA6ASmANGAYwHsIAXOMpMAGwEsAjAJykYE8AKcqagSgB0ItMnGYFStAG5wABAB4AtNIBmAVwhjaJdj2kAVLAFUAogIFpUcxUNql2A6dIAmUUlGkBeaV2oB9Z6-YASSxAgGUPaVpGWgBnXGkAWV0AYQBBLHDPGFICFhieXHtpGCJHFWo4GIiSsoqY9jgAD1hUCp8a8rhtfggdAB8APiKa2iVWH3FSCs4bCoi+MGSVGNIiGC9ZuAWegVHpdiFyUXEpbukQIpiACyFWVPR2cwASFVp455iRKUYegF8wX4AXSAA" style="height: 800px; width: 100vw; max-width: 1400px; border: 1px solid rgba(0,0,0,0.175); border-radius: .375rem; position: absolute; left: 50\%; margin-top: 30px; transform: translateX(-50\%); z-index: 1"></iframe>}}
    \if{html}{\out{<a style='height: 800px; display: block;'></a>}}
  }
  \item{example-2}{
    \href{https://shinylive.io/r/app/#code=NobwRAdghgtgpmAXGKAHVA6ASmANGAYwHsIAXOMpMAGwEsAjAJykYE8AKcqagSgB0ItMnGYFStAG5wABAB4AtNIBmAVwhjaJdj2kAVLAFUAogIFpUcxUNql2A6dIAmUUlGkBeaV2oB9Z6-YASSxAgGUPaVpGWgBnHlx7aRgiRxVqOBiI5NT0mPY4AA9YVHSfbLS4bX4IHQAfAD5E7NolVh8ACzgoRxF89PgyCNcAcxiAEkdJdnaAZjswAGEVGNIiGGlO7pE+MB4900ElaXYhclFxKSrpEESY9qFWAEF0dnMxlVpcaTeYkSlGaoAXzAgIAukA}{Open in Shinylive}
    \if{html}{\out{<iframe class="iframe_shinylive" src="https://shinylive.io/r/app/#code=NobwRAdghgtgpmAXGKAHVA6ASmANGAYwHsIAXOMpMAGwEsAjAJykYE8AKcqagSgB0ItMnGYFStAG5wABAB4AtNIBmAVwhjaJdj2kAVLAFUAogIFpUcxUNql2A6dIAmUUlGkBeaV2oB9Z6-YASSxAgGUPaVpGWgBnHlx7aRgiRxVqOBiI5NT0mPY4AA9YVHSfbLS4bX4IHQAfAD5E7NolVh8ACzgoRxF89PgyCNcAcxiAEkdJdnaAZjswAGEVGNIiGGlO7pE+MB4900ElaXYhclFxKSrpEESY9qFWAEF0dnMxlVpcaTeYkSlGaoAXzAgIAukA" style="height: 800px; width: 100vw; max-width: 1400px; border: 1px solid rgba(0,0,0,0.175); border-radius: .375rem; position: absolute; left: 50\%; margin-top: 30px; transform: translateX(-50\%); z-index: 1"></iframe>}}
    \if{html}{\out{<a style='height: 800px; display: block;'></a>}}
  }
  \item{example-3}{
    \href{https://shinylive.io/r/app/#code=NobwRAdghgtgpmAXGKAHVA6ASmANGAYwHsIAXOMpMAGwEsAjAJykYE8AKcqagSgB0ItMnGYFStAG5wABAB4AtNIBmAVwhjaJdj2kAVLAFUAogIFpUcxUNql2A6dIAmUUlGkBeaV2oB9Z6-YASSxAgGUPaVpGWgBnHlx7aRgiRxVqOBiI5NT0mPY4AA9YVHSfbLS4bX4IHQAfAD5E7NolVh8lIiJyRnz0+DIIvjAAYRUY0iIYZU7uoeqBFul2IW6oDSkq6RBEmIALIVYAQXR2cwASFVpcaXOYkSlGaoBfMCeAXSA}{Open in Shinylive}
    \if{html}{\out{<iframe class="iframe_shinylive" src="https://shinylive.io/r/app/#code=NobwRAdghgtgpmAXGKAHVA6ASmANGAYwHsIAXOMpMAGwEsAjAJykYE8AKcqagSgB0ItMnGYFStAG5wABAB4AtNIBmAVwhjaJdj2kAVLAFUAogIFpUcxUNql2A6dIAmUUlGkBeaV2oB9Z6-YASSxAgGUPaVpGWgBnHlx7aRgiRxVqOBiI5NT0mPY4AA9YVHSfbLS4bX4IHQAfAD5E7NolVh8lIiJyRnz0+DIIvjAAYRUY0iIYZU7uoeqBFul2IW6oDSkq6RBEmIALIVYAQXR2cwASFVpcaXOYkSlGaoBfMCeAXSA" style="height: 800px; width: 100vw; max-width: 1400px; border: 1px solid rgba(0,0,0,0.175); border-radius: .375rem; position: absolute; left: 50\%; margin-top: 30px; transform: translateX(-50\%); z-index: 1"></iframe>}}
    \if{html}{\out{<a style='height: 800px; display: block;'></a>}}
  }
}
}

