% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_stress.R
\docType{data}
\name{stress_data}
\alias{stress_data}
\alias{san_andreas}
\alias{tibet}
\alias{iceland}
\title{Example crustal stress dataset}
\format{
A \code{sf} object / \code{data.frame} with 10 columns. Each row represents a different in-situ stress measurement:
\describe{
\item{id}{Measurement identifier}
\item{lat}{latitude in degrees}
\item{lon}{longitude in degrees}
\item{azi}{SHmax azimuth in degrees}
\item{unc}{MMeasruement standard eviation (in degrees)}
\item{type}{Type of measurement}
\item{depth}{Depth in km}
\item{quality}{WSM quality rank}
\item{regime}{Stress regime}
}

An object of class \code{sf} (inherits from \code{data.frame}) with 407 rows and 10 columns.

An object of class \code{sf} (inherits from \code{data.frame}) with 947 rows and 10 columns.

An object of class \code{sf} (inherits from \code{data.frame}) with 201 rows and 10 columns.
}
\source{
\url{https://www.world-stress-map.org/}
}
\usage{
data('san_andreas')

data('tibet')

data('iceland')
}
\description{
Subsets of the World Stress Map (WSM) compilation of information on the
crustal present-day stress field (Version 1.1. 2019).
}
\details{
\describe{
\item{\verb{'san_andreas"}}{contains 407 stress data adjacent to the San Andreas
Fault to be tested against a tangentially displaced plate boundary.}
\item{\code{"tibet"}}{ contains 947 stress data from the Himalaya and Tibetan
plateau to be tested against an inward-moving displaced plate boundary.}
\item{\verb{'iceland}}{contains 201 stress data from Iceland to be tested against a
outward-moving displaced plate boundary.}
}
}
\examples{
data("san_andreas")
head(san_andreas)

data("tibet")
head(tibet)

data("iceland")
head(iceland)
}
\references{
Heidbach, O., M. Rajabi, X. Cui, K. Fuchs, B. M<U+00FC>ller, J.
Reinecker, K. Reiter, M. Tingay, F. Wenzel, F. Xie, M. O. Ziegler,
M.-L. Zoback, and M. D. Zoback (2018): The World Stress Map database
release 2016: Crustal stress pattern across scales. \emph{Tectonophysics},
\strong{744}, 484-498, \doi{10.1016/j.tecto.2018.07.007}.
}
\seealso{
\code{\link[=download_WSM2016]{download_WSM2016()}} for description of columns and stress regime
acronyms
}
\keyword{datasets}
