% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{tmplUpdate}
\alias{tmplAsFun}
\alias{tmplEval}
\alias{tmplUpdate}
\alias{tmplUpdate.function}
\alias{tmplUpdate.tmpl}
\title{Update and evaluate templates}
\usage{
tmplUpdate(.t, ...)

\method{tmplUpdate}{tmpl}(.t, ...)

\method{tmplUpdate}{function}(.t, ...)

tmplEval(.t, ..., .envir = new.env(parent = parent.frame()))

tmplAsFun(.t, ...)
}
\arguments{
\item{.t}{(tmpl) and object of class 'tmpl'}

\item{...}{(name = value | name ~ value) name-value expressions used to
update the snippets in \code{x}}

\item{.envir}{(environment) the environment in which the template is
evaluated}
}
\description{
Functions operating on \link{tmpl} objects. They can be updated and / or
evaluated as an expression.
}
\details{
\code{tmplUpdate} will evaluate all snippets in a template. Objects are
searched for in the list of arguments supplied as \code{...} and the
environment of the template. The results are substituted with the snippts.

\code{tmplEval} will evaluate the template in place or in the specified
evironment after substituting the elements in \code{...}.
}
\examples{
tmpl("This is {{ a }} very similar to {{ b }}", a = "actually", b = "sprintf")
tmpl("But I consider it to be ({{ sprintf('\%i', a) }}) orthogonal", a = 1.0)
tmpl("and ({{ sprintf('\%i', b) }}) with a different scope:", b = 2.0)
tmpl("SELECT {{ var }} FROM {{ table }} WHERE {{ condition }};",
     var = "someVar", table = "someTable", condition = "primaryKey = 1")
template <- tmpl("cat({{ toupper(x) }})")
tmplUpdate(template, x ~ "hi")
tmplEval(template, x ~ "hi")

}

