% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raw2scaled.R
\name{raw2scaled}
\alias{raw2scaled}
\title{Convert raw neuropsychological test scores to scaled scores.}
\usage{
raw2scaled(
  data = NULL,
  test = NULL,
  test.min = NULL,
  test.max = NULL,
  test.better = c("High", "Low"),
  group.id = NULL,
  control.id = NULL,
  all.controls = FALSE,
  rnd.s = FALSE
)
}
\arguments{
\item{data}{a data frame containing the test score}

\item{test}{a character string specifying the name of the variable containing
the test score}

\item{test.min}{a real number indicating the smallest possible test score}

\item{test.max}{a real number indicating the largest possible test score}

\item{test.better}{a character string indicating direction of the scores.
Use "High" if high test scores imply better performance, use "Low" otherwise.}

\item{group.id}{a character string specifying the name of the variable
containing group identification (i.e. control vs exposed/test/risk). Ignored,
if all.controls = TRUE.}

\item{control.id}{a character string specifying the label of the control
group within group.id variable. Ignored, if all.controls = TRUE.}

\item{all.controls}{a logical indicating whether all observations should be
treated as controls. Overwrites group.id and control.id.}

\item{rnd.s}{a logical indicating whether the scaled scores should be
rounded. Default is FALSE.}
}
\value{
A list consisting of 3 objects. The first two are vectors containing the
original raw test scores and the calculated scaled scores. The third object
in the list, called \code{SS.maps}, contains conversions from raw scores to
scaled scores in a form of a table with two columns, one representing scaled
scores (one per row) and one representing raw scores (a single value or range
of raw values corresponding to each scaled score). Note that this table
shows rounded scaled scores regardless of the value for \code{rnd.s}.
}
\description{
Convert raw neuropsychological test scores to scaled scores.
}
\details{
The \code{raw2scaled()} function can be used by neuropsychologists, who wish
to convert raw test scores to scaled scores (mean=10, SD=3), using methods
described in Heaton et al. (2003 & 2009). The raw test scores that have many
decimal digits should be rounded to fewer digits prior to the application of
the \code{raw2scaled()} function. This will significantly reduce software
running time. The recommended number of decimal digits is 4 or fewer. Values
below \code{test.min} or above \code{test.max} will result in NA. Detailed
description of the procedure will be found in Umlauf et al. (In revision).

Note that the function does not guarantee that the calculated scaled scores
range from 0 to 20, because it uses normal distribution quantiles. Therefore,
scaled scores outside 0-20 range are possible.
}
\examples{
data(PsychTestData)
raw2scaled(data = PsychTestData, test = "rawscore",
           test.min = 0, test.max = 36, test.better = "High",
           group.id = "group", control.id = "control")
}
\references{
Umlauf A et al. (2022) Automated procedure for demographic adjustments on
cognitive test scores. Manuscript submitted for publication.

Heaton RK, Taylor MJ, & Manly J (2003) Demographic effects and use of
demographically corrected norms with the WAIS-III and WMS-III. In: Tulsky D
et al. (Eds.) \emph{Clinical Interpretation of the WAIS-III and WMS-III}.
San Diego, CA: Academic Press, 183-210.

Heaton RK, Ryan L, & Grant I (2009) Demographic influences and use of
demographically corrected norms in neuropsychological assessment. In Grant I
& Adams KM (Eds.) \emph{Neuropsychological Assessment of Neuropsychiatric
and Neuromedical Disorders}. New York, NY: Oxford University Press, 127-155.
}
\author{
Anya Umlauf
}
