% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tts.R
\name{tts}
\alias{tts}
\alias{tts_amazon}
\alias{tts_google}
\alias{tts_microsoft}
\alias{tts_coqui}
\title{Text-to-Speech (Speech Synthesis)}
\usage{
tts(
  text,
  output_format = c("mp3", "wav"),
  service = c("amazon", "google", "microsoft", "coqui"),
  bind_audio = TRUE,
  ...
)

tts_amazon(
  text,
  output_format = c("mp3", "wav"),
  voice = "Joanna",
  bind_audio = TRUE,
  save_local = FALSE,
  save_local_dest = NULL,
  ...
)

tts_google(
  text,
  output_format = c("mp3", "wav"),
  voice = "en-US-Standard-C",
  bind_audio = TRUE,
  save_local = FALSE,
  save_local_dest = NULL,
  ...
)

tts_microsoft(
  text,
  output_format = c("mp3", "wav"),
  voice = NULL,
  bind_audio = TRUE,
  save_local = FALSE,
  save_local_dest = NULL,
  ...
)

tts_coqui(
  text,
  exec_path,
  output_format = c("wav", "mp3"),
  model_name = "tacotron2-DDC_ph",
  vocoder_name = "ljspeech/univnet",
  bind_audio = TRUE,
  save_local = FALSE,
  save_local_dest = NULL,
  ...
)
}
\arguments{
\item{text}{A character vector of text to be spoken}

\item{output_format}{Format of output files: "mp3" or "wav"}

\item{service}{Service to use (Amazon, Google, Microsoft, or Coqui)}

\item{bind_audio}{Should the \code{\link[=tts_bind_wav]{tts_bind_wav()}} be run on after
the audio has been created, to ensure that the length of text and the
number of rows is consistent?}

\item{...}{Additional arguments}

\item{voice}{Full voice name}

\item{save_local}{Should the audio file be saved locally?}

\item{save_local_dest}{If to be saved locally, destination where output file
will be saved}

\item{exec_path}{System path to Coqui TTS executable}

\item{model_name}{(Coqui TTS only) Deep Learning model for Text-to-Speech
Conversion}

\item{vocoder_name}{(Coqui TTS only) Voice coder used for speech coding and
transmission}
}
\value{
A standardized \code{tibble} featuring the following columns:
\itemize{
\item \code{index} : Sequential identifier number
\item \code{original_text} : The text input provided by the user
\item \code{text} : In case original_text exceeds the character limit, text represents the outcome of splitting original_text. Otherwise, text remains the same as original_text.
\item \code{wav} : Wave object (S4 class)
\item \code{file} : File path to the audio file
\item \code{audio_type} : The audio format, either mp3 or wav
\item \code{duration} : The duration of the audio file
\item \code{service} : The text-to-speech engine used
}
}
\description{
Convert text-to-speech using various engines, including Amazon
Polly, Coqui TTS, Google Cloud Text-to-Speech API, and Microsoft Cognitive
Services Text to Speech REST API.

With the exception of Coqui TTS, all these engines are accessible as R
packages:
\itemize{
\item \href{https://github.com/cloudyr/aws.polly}{aws.polly} is a client for Amazon Polly.
\item \href{https://github.com/ropensci/googleLanguageR}{googleLanguageR} is a client to the Google Cloud Text-to-Speech API.
\item \href{https://github.com/fhdsl/conrad}{conrad} is a client to the Microsoft Cognitive Services Text to Speech REST API
}
}
\examples{
\dontrun{
# Amazon Polly
tts("Hello world! This is Amazon Polly", service = "amazon")

tts("Hello world! This is Coqui TTS", service = "coqui")

tts("Hello world! This is Google Cloud", service = "google")

tts("Hello world! This is Microsoft", service = "microsoft")
}
}
