% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FitLdaModel.R
\name{FitLdaModel}
\alias{FitLdaModel}
\title{Fit a topic model using Latent Dirichlet Allocation}
\usage{
FitLdaModel(dtm, k, iterations = NULL, alpha = 0.1, beta = 0.05,
  smooth = TRUE, method = "gibbs", return_all = FALSE, ...)
}
\arguments{
\item{dtm}{A document term matrix of class \code{dgCMatrix}}

\item{k}{Number of topics}

\item{iterations}{The number of Gibbs iterations if \code{method = 'gibbs'}}

\item{alpha}{Dirichlet parameter for the distribution of topics over documents. 
Defaults to 0.1}

\item{beta}{Dirichlet parameter for the distribution of words over topics. 
Defaults to 0.05}

\item{smooth}{Logical indicating whether or not you want to smooth the 
probabilities in the rows of \code{phi} and \code{theta}.}

\item{method}{One of either 'gibbs' or 'vem' for either Gibbs sampling or 
variational expectation maximization. Defaults to 'gibbs'. See details, below.}

\item{return_all}{Logical. Do you want the raw results of the underlying 
function returned along with the formatted results? Defaults to \code{TRUE}.}

\item{...}{Other arguments to pass to underlying functions. See details, below.}
}
\value{
Returns a list with a minumum of two objects, \code{phi} and 
\code{theta}. The rows of \code{phi} index topics and the columns index tokens.
The rows of \code{theta} index documents and the columns index topics.
}
\description{
A wrapper for two implementations of Latent Dirichlet 
Allocation that returns a nicely-formatted topic model. See details, below.
}
\details{
For \code{method = 'gibbs'} this is a wrapper for \code{\link[lda]{lda.collapsed.gibbs.sampler}} 
from the \code{lda} package. Additional arguments can be passed to
 \code{\link[lda]{lda.collapsed.gibbs.sampler}} through \code{...}. However, there are some
arguments that, if passed through \code{...}, can cause conflicts. The 
arguments \code{K}, \code{alpha}, and \code{eta} for 
 \code{\link[lda]{lda.collapsed.gibbs.sampler}} are set with the arguments \code{k}, 
\code{alpha}, and \code{beta}, respectively. The arguments \code{documents} 
and \code{vocab} for  \code{\link[lda]{lda.collapsed.gibbs.sampler}} are set by \code{dtm} 
and aren't required. 

For \code{method = 'vem'}, this function is a wrapper for \code{LDA} from the
\code{topicmodels} library. Arguments to \code{\link[topicmodels]{LDA}}'s \code{control}
argument are passed through \code{...}. \code{\link[topicmodels]{LDA}}, by default, has behavior
worth noting. By default, it estimates \code{alpha} and \code{beta} as part
of the expectation maximization. Therefore, the values of \code{alpha} and 
\code{beta} passed to \code{\link[topicmodels]{LDA}} will change unless \code{estimate.alpha} and
\code{estimate.beta} are passed to \code{...} and set to \code{FALSE}.
}
\examples{
# Load a pre-formatted dtm 
data(nih_sample_dtm) 

# Fit an LDA model on a sample of documents
model <- FitLdaModel(dtm = nih_sample_dtm[ sample(1:nrow(nih_sample_dtm), 20), ], 
                     k = 5, iterations = 200)

str(model)

# Fit a model, include likelihoods passed to lda::lda.collapsed.gibbs.sampler
model <- FitLdaModel(dtm = nih_sample_dtm[ sample(1:nrow(nih_sample_dtm), 20), ], 
                     k = 5, iterations = 200, compute.log.likelihood = TRUE)

str(model)
}

