% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textplot_corglasso.R
\name{textplot_correlation_glasso}
\alias{textplot_correlation_glasso}
\alias{textplot_correlation_glasso.default}
\title{Plot sparse term correlations as a graph structure}
\usage{
textplot_correlation_glasso(x, ...)

\method{textplot_correlation_glasso}{default}(
  x,
  n = 1000,
  exclude_zero = TRUE,
  label.cex = 1,
  node.width = 0.5,
  ...
)
}
\arguments{
\item{x}{a correlation matrix}

\item{...}{further arguments passed on to \code{qgraph::qgraph},
except layout which is set to 'spring', labels (taken from the colnames of \code{x}),
and borders which is set to FALSE.}

\item{n}{sample size used in computing the sparse correlation matrix. Defaults to 1000.}

\item{exclude_zero}{logical indicating to exclude zero-correlations from the graph}

\item{label.cex}{passed on to \code{qgraph::qgraph}}

\item{node.width}{passed on to \code{qgraph::qgraph}}
}
\value{
an object of class ggplot
}
\description{
Plot sparse term correlations as a graph structure.
Uses the glasso procedure (\code{glasso::glassopath}) to reduce the correlation matrix to retain only the
relevant correlations and next visualises these sparse correlations.
}
\examples{
library(udpipe)
data(brussels_reviews_anno, package = 'udpipe')
x <- subset(brussels_reviews_anno, xpos \%in\% "NN" & language \%in\% "fr" & !is.na(lemma))
x <- document_term_frequencies(x, document = "doc_id", term = "lemma")
dtm <- document_term_matrix(x)
dtm <- dtm_remove_lowfreq(dtm, maxterms = 60)

m <- dtm_cor(dtm)
textplot_correlation_glasso(m, exclude_zero = TRUE)
\donttest{
textplot_correlation_glasso(m, exclude_zero = FALSE)
}
}
