% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_table.R
\name{tidy_table}
\alias{tidy_table}
\title{Tidy a Table: Bind Its Values with Its Names}
\usage{
tidy_table(x, id.name = "id", content.name = "content",
  as.tibble = tibble_output(), ...)
}
\arguments{
\item{x}{A \code{\link[base]{table}}.}

\item{id.name}{The name to use for the column created from the \code{\link[base]{table}}
\code{\link[base]{names}}.}

\item{content.name}{The name to use for the column created from the \code{\link[base]{table}}
values.}

\item{as.tibble}{logical.  If \code{TRUE} the output class will be set to a
\pkg{tibble}, otherwise a \code{\link[data.table]{data.table}}.  Default
checks \code{getOption("tibble.out")} as a logical.  If this is \code{NULL}
the default \code{\link[textshape]{tibble_output}} will set \code{as.tibble}
to \code{TRUE} if \pkg{dplyr} is loaded.  Otherwise, the output will be a
\code{\link[data.table]{data.table}}.}

\item{\ldots}{ignored.}
}
\value{
Returns a \code{\link[data.table]{data.table}} with the \code{\link[base]{names}}
from the \code{\link[base]{table}} as an \code{id} column.
}
\description{
\code{\link[base]{cbind}} a \code{\link[base]{table}}'s values with its
\code{\link[base]{names}} to form \code{id} (from the names) and
\code{content} columns.
}
\examples{
x <- table(sample(LETTERS[1:6], 1000, TRUE))
tidy_table(x)
}

