% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shape_text.R
\name{text_width}
\alias{text_width}
\title{Calculate the width of a string, ignoring new-lines}
\usage{
text_width(
  strings,
  family = "",
  italic = FALSE,
  bold = FALSE,
  size = 12,
  res = 72,
  include_bearing = TRUE,
  path = NULL,
  index = 0
)
}
\arguments{
\item{strings}{A character vector of strings}

\item{family}{The name of the font family}

\item{italic}{logicals indicating the font style}

\item{bold}{logicals indicating the font style}

\item{size}{The pointsize of the font to use for size related measures}

\item{res}{The ppi of the size related mesures}

\item{include_bearing}{Logical, should left and right bearing be included in
the string width?}

\item{path, index}{path an index of a font file to circumvent lookup based on
family and style}
}
\value{
A numeric vector giving the width of the strings in pixels. Use the
provided \code{res} value to convert it into absolute values.
}
\description{
This is a very simple alternative to \code{\link[=shape_string]{shape_string()}} that simply calculates
the width of strings without taking any newline into account. As such it is
suitable to calculate the width of words or lines that has already been
splitted by \verb{\\n}. Input is recycled to the length of \code{strings}.
}
\examples{
strings <- c('A short string', 'A very very looong string')
text_width(strings)

}
