% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_from_datasets.R
\name{sample_from_datasets}
\alias{sample_from_datasets}
\title{Samples elements at random from the datasets in \code{datasets}.}
\usage{
sample_from_datasets(datasets, weights = NULL, seed = NULL)
}
\arguments{
\item{datasets}{A list ofobjects with compatible structure.}

\item{weights}{(Optional.) A list of \code{length(datasets)} floating-point values where
\code{weights[[i]]} represents the probability with which an element should be sampled
from \code{datasets[[i]]}, or a dataset object where each element is such a list.
Defaults to a uniform distribution across \code{datasets}.

[[i]: R:[i
[[i]: R:[i}

\item{seed}{(Optional.) An integer, representing the random seed
that will be used to create the distribution.}
}
\value{
A dataset that interleaves elements from \code{datasets} at random, according to
\code{weights} if provided, otherwise with uniform probability.
}
\description{
Samples elements at random from the datasets in \code{datasets}.
}
