% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset_iterators.R
\name{until_out_of_range}
\alias{until_out_of_range}
\alias{out_of_range_handler}
\title{Execute code that traverses a dataset until an out of range condition occurs}
\usage{
until_out_of_range(expr)

out_of_range_handler(e)
}
\arguments{
\item{expr}{Expression to execute (will be executed multiple times until
the condition occurs)}

\item{e}{Error object}
}
\description{
Execute code that traverses a dataset until an out of range condition occurs
}
\details{
When a dataset iterator reaches the end, an out of range runtime error
will occur. This function will catch and ignore the error when it occurs.
}
\examples{
\dontrun{
library(tfdatasets)
dataset <- text_line_dataset("mtcars.csv", record_spec = mtcars_spec) \%>\%
  dataset_batch(128) \%>\%
  dataset_repeat(10) \%>\%
  dataset_prepare(x = c(mpg, disp), y = cyl)

iter <- make_iterator_one_shot(dataset)
next_batch <- iterator_get_next(iter)

until_out_of_range({
  batch <- sess$run(next_batch)
  # use batch$x and batch$y tensors
})
}

}
