% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset_methods.R
\name{as_tensor.tensorflow.python.data.ops.dataset_ops.DatasetV2}
\alias{as_tensor.tensorflow.python.data.ops.dataset_ops.DatasetV2}
\alias{get_single_element}
\alias{as.array.tensorflow.python.data.ops.dataset_ops.DatasetV2}
\title{Get the single element of the dataset.}
\usage{
\method{as_tensor}{tensorflow.python.data.ops.dataset_ops.DatasetV2}(x, ..., name = NULL)

\method{as.array}{tensorflow.python.data.ops.dataset_ops.DatasetV2}(x, ...)
}
\arguments{
\item{x}{A TF Dataset}

\item{...}{passed on to \code{tensorflow::as_tensor()}}

\item{name}{(Optional.) A name for the TensorFlow operation.}
}
\description{
The function enables you to use a TF Dataset in a stateless "tensor-in
tensor-out" expression, without creating an iterator. This facilitates the
ease of data transformation on tensors using the optimized TF Dataset
abstraction on top of them.
}
\details{
For example, consider a \code{preprocess_batch()} which would take as an input
a batch of raw features and returns the processed feature.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{preprocess_one_case <- function(x) x + 100

preprocess_batch   <- function(raw_features) \{
  batch_size <- dim(raw_features)[1]
  ds <- raw_features \%>\%
    tensor_slices_dataset() \%>\%
    dataset_map(preprocess_one_case, num_parallel_calls = batch_size) \%>\%
    dataset_batch(batch_size)
  as_tensor(ds)
\}

raw_features <- array(seq(prod(4, 5)), c(4, 5))
preprocess_batch(raw_features)
}\if{html}{\out{</div>}}

In the above example, the batch of \code{raw_features} was converted to a TF
Dataset. Next, each of the raw_feature cases in the batch was mapped using
the preprocess_one_case and the processed features were grouped into a single
batch. The final dataset contains only one element which is a batch of all
the processed features.

Note: The dataset should contain only one element. Now, instead of creating
an iterator for the dataset and retrieving the batch of features, the
\code{as_tensor()} function is used to skip the iterator creation process and
directly output the batch of features.

This can be particularly useful when your tensor transformations are
expressed as TF Dataset operations, and you want to use those transformations
while serving your model.
}
\seealso{
\itemize{
\item \url{https://www.tensorflow.org/api_docs/python/tf/data/Dataset#get_single_element}
}
}
