% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset_methods.R
\name{length.tf_dataset}
\alias{length.tf_dataset}
\alias{length.tensorflow.python.data.ops.dataset_ops.DatasetV2}
\title{Get Dataset length}
\usage{
\method{length}{tf_dataset}(x)

\method{length}{tensorflow.python.data.ops.dataset_ops.DatasetV2}(x)
}
\arguments{
\item{x}{a \code{tf.data.Dataset} object.}
}
\value{
Either \code{Inf} if the dataset is infinite, \code{NA} if the dataset length
is unknown, or an R numeric if it is known.
}
\description{
Returns the length of the dataset.
}
\examples{
\dontrun{
range_dataset(0, 42) \%>\% length()
# 42

range_dataset(0, 42) \%>\% dataset_repeat() \%>\% length()
# Inf

range_dataset(0, 42) \%>\% dataset_repeat() \%>\%
  dataset_filter(function(x) TRUE) \%>\% length()
# NA
}
}
