% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/train_and_evaluate.R
\name{eval_spec}
\alias{eval_spec}
\title{Configuration for the eval component of \code{train_and_evaluate}}
\usage{
eval_spec(input_fn, steps = 100, name = NULL, hooks = NULL,
  exporters = NULL, start_delay_secs = 120, throttle_secs = 600)
}
\arguments{
\item{input_fn}{Evaluation input function returning a tuple of:
\itemize{
\item features - \code{Tensor} or dictionary of string feature name to \code{Tensor}.
\item labels - \code{Tensor} or dictionary of \code{Tensor} with labels.
}}

\item{steps}{Positive number of steps for which to evaluate model.
If \code{NULL}, evaluates until \code{input_fn} raises an end-of-input exception.}

\item{name}{Name of the evaluation if user needs to run multiple
evaluations on different data sets. Metrics for different evaluations
are saved in separate folders, and appear separately in tensorboard.}

\item{hooks}{List of session run hooks to run
during evaluation.}

\item{exporters}{List of \code{Exporter}s, or a single one, or \code{NULL}.
\code{exporters} will be invoked after each evaluation.}

\item{start_delay_secs}{Start evaluating after waiting for this many
seconds.}

\item{throttle_secs}{Do not re-evaluate unless the last evaluation was
started at least this many seconds ago. Of course, evaluation does not
occur if no new checkpoints are available, hence, this is the minimum.}
}
\description{
\code{EvalSpec} combines details of evaluation of the trained model as well as its
export. Evaluation consists of computing metrics to judge the performance of
the trained model. Export writes out the trained model on to external
storage.
}
\seealso{
Other training methods: \code{\link{train_and_evaluate.tf_estimator}},
  \code{\link{train_spec}}
}
