# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Predict OTU functional potential via PICRUSt
#'
#' Given an OTU abundance table prepared with the GreenGenes reference database,
#' this function predicts the functional content using either COG or KO
#' precalculated mapping tables that map the taxonomic abundance for a given OTU
#' to functional abundance content across a set of functional genes.
#'
#' @param file_path Path to the precalculated table
#' @param otu_id_targets Character vector of OTU IDs to predict
#'
#' @return A list containing
#' \describe{
#' \item{gene_ids}{String vector of KO IDs, the column names in genome_table_out.}
#' \item{pimeta_ids}{String vector of names for the PICRUSt metadata categories,
#' the column names of pimeta_table_out.}
#' \item{matches}{String vector of OTU IDs from otu_id_targets that were present
#' in the mapping file.}
#' \item{genemeta}{String vector of functional metadata corresponding to gene_ids}
#' \item{genome_table_out}{Integer matrix of gene counts across topics}
#' \item{pimeta_table_out}{Numeric matrix of method specific metadata (NSTI)}
#' }
picrust_otu <- function(file_path, otu_id_targets) {
    .Call(`_themetagenomics_picrust_otu`, file_path, otu_id_targets)
}

