% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-helpers.R
\name{make_TIRT_data}
\alias{make_TIRT_data}
\title{Prepare data for Thurstonian IRT models}
\usage{
make_TIRT_data(
  data,
  blocks,
  direction = c("larger", "smaller"),
  format = c("ranks", "pairwise"),
  family = "bernoulli",
  partial = FALSE,
  range = c(0, 1)
)
}
\arguments{
\item{data}{An object of class \code{data.frame} containing data of all
variables used in the model.}

\item{blocks}{Object of class \code{TIRTblocks} generated by
\code{\link{set_block}} indicating which items belong to which block, trait
and more. Ignored if data already contains information on the blocks.}

\item{direction}{Indicates if \code{"larger"} (the default) or
\code{"smaller"} input values are considered as indicating the favored
answer.}

\item{format}{Format of the item responses. Either \code{"ranks"} for
responses in ranked format or \code{"pairwise"} for responses in pairwise
comparison format. If \code{"ranks"}, each item must have its own
column in the data frame which contains its ranks within the block.
If \code{"pairwise"}, each existing item combination must have its
own column named after the combination of the two compared items.}

\item{family}{Name of assumed the response distribution. Either
\code{"bernoulli"}, \code{"cumulative"}, or \code{"gaussian"}.}

\item{partial}{A flag to indicate whether partial comparisons are allowed
for responses stored in the \code{"ranks"} format.}

\item{range}{Numeric vector of length two giving the range of the
responses when using the \code{"pairwise"} format. Defaults
to \code{c(0, 1)} for use with dichotomous responses.}
}
\value{
A \code{data.frame} in a specific format and with attributes ready
  for use with other functions of the \pkg{ThurstonianIRT} package.
}
\description{
Prepare data for Thurstonian IRT models
}
\examples{
# load the data
data("triplets")

# define the blocks of items
blocks <-
  set_block(c("i1", "i2", "i3"), traits = c("t1", "t2", "t3"),
          signs = c(1, 1, 1)) +
  set_block(c("i4", "i5", "i6"), traits = c("t1", "t2", "t3"),
            signs = c(-1, 1, 1)) +
  set_block(c("i7", "i8", "i9"), traits = c("t1", "t2", "t3"),
            signs = c(1, 1, -1)) +
  set_block(c("i10", "i11", "i12"), traits = c("t1", "t2", "t3"),
            signs = c(1, -1, 1))

# generate the data to be understood by 'thurstonianIRT'
triplets_long <- make_TIRT_data(
  data = triplets, blocks = blocks, direction = "larger",
  format = "pairwise", family = "bernoulli", range = c(0, 1)
)

\donttest{
# fit the data using Stan
fit <- fit_TIRT_stan(triplets_long, chains = 1)
print(fit)
predict(fit)
}

}
