% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repair-names.R
\name{repair_names}
\alias{repair_names}
\title{Repair object names.}
\usage{
repair_names(x, prefix = "V", sep = "")
}
\arguments{
\item{x}{A named vector.}

\item{prefix}{A string, the prefix to use for new column names.}

\item{sep}{A string inserted between the column name and de-duplicating
number.}
}
\value{
\code{x} with valid names.
}
\description{
\code{repair_names()} ensures its input has non-missing and
unique names (duplicated names get a numeric suffix). Valid names are
left as is.
}
\examples{
repair_names(list(3, 4, 5)) # works for lists, too
repair_names(mtcars) # a no-op
tbl <- as_tibble(structure(list(3, 4, 5), class = "data.frame"),
                 validate = FALSE)
repair_names(tbl)
}
