% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate-profiles.R
\name{get_estimates}
\alias{get_estimates}
\alias{get_estimates.tidyLPA}
\alias{get_estimates.tidyProfile}
\title{Get estimates from objects generated by tidyLPA}
\usage{
get_estimates(x, ...)

\method{get_estimates}{tidyLPA}(x, ...)

\method{get_estimates}{tidyProfile}(x, ...)
}
\arguments{
\item{x}{An object generated by tidyLPA.}

\item{...}{further arguments to be passed to or from other methods. They are
ignored in this function.}
}
\value{
A tibble.
}
\description{
Get estimates from objects generated by tidyLPA.
}
\section{Methods (by class)}{
\itemize{
\item \code{tidyLPA}: Get estimates for a latent profile analysis with
multiple numbers of classes and models, of class 'tidyLPA'.

\item \code{tidyProfile}: Get estimates for a single latent profile analysis
object, of class 'tidyProfile'.
}}

\examples{
\dontrun{
if(interactive()){
 results <- iris \%>\%
   select(Sepal.Length, Sepal.Width, Petal.Length, Petal.Width) \%>\%
   estimate_profiles(3)
 get_estimates(results)
 get_estimates(results[[1]])
 }
}
}
\author{
Caspar J. van Lissa
}
