% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_draws.R
\name{add_draws}
\alias{add_draws}
\title{Add draws to a data frame in tidy format}
\usage{
add_draws(data, draws, value = ".value")
}
\arguments{
\item{data}{Data frame to add draws to, with M rows.}

\item{draws}{N by M matrix of draws, with M columns corresponding to the M rows in \code{data}, and N draws in each column.}

\item{value}{The name of the output column; default \code{".value"}.}
}
\value{
A data frame (actually, a \link[tibble:tibble]{tibble}) with a \code{.row} column (a
factor grouping rows from the input \code{data}), a \code{.draw} column (a unique index corresponding to each draw
from the distribution), and a column with its name specified by the \code{value} argument (default is \code{.value})
containing the values of draws from \code{draws}. The data frame is grouped by all rows in \code{data} plus the \code{.row} column.
}
\description{
Add draws from a matrix of draws (usually draws from a predictive distribution) to a data frame in tidy format. This is
a generic version of \code{\link[=add_predicted_draws]{add_predicted_draws()}} that can be used with model types
that have their own prediction functions that are not yet supported by tidybayes.
}
\details{
Given a data frame with M rows and an N by M matrix of N draws, adds a \code{.row}, \code{.draw}, and \code{.value}
column (or another name if \code{value} is set) to \code{data}, and expands \code{data} into a long-format dataframe of draws.

\code{add_epred_draws(df, m)} is roughly equivalent to \code{add_draws(df, posterior_epred(m, newdata = df))}, except
that \code{add_epred_draws} standardizes argument names and values across packages and has additional features for some
model types (like handling ordinal responses and distributional parameters in brms).

\code{add_predicted_draws(df, m)} is roughly equivalent to \code{add_draws(df, posterior_predict(m, newdata = df))}, except
that \code{add_predicted_draws} standardizes argument names and values across packages.
}
\examples{
\donttest{

library(ggplot2)
library(dplyr)

if (
  require("brms", quietly = TRUE) &&
  require("modelr", quietly = TRUE)
) {

  theme_set(theme_light())

  m_mpg = brm(mpg ~ hp * cyl, data = mtcars,
    # 1 chain / few iterations just so example runs quickly
    # do not use in practice
    chains = 1, iter = 500)

  # plot posterior predictive intervals
  mtcars \%>\%
    group_by(cyl) \%>\%
    data_grid(hp = seq_range(hp, n = 101)) \%>\%
    # the line below is roughly equivalent to add_epred_draws(m_mpg), except
    # that it does not standardize arguments across model types.
    add_draws(posterior_epred(m_mpg, newdata = .)) \%>\%
    ggplot(aes(x = hp, y = mpg, color = ordered(cyl))) +
    stat_lineribbon(aes(y = .value), alpha = 0.25) +
    geom_point(data = mtcars) +
    scale_fill_brewer(palette = "Greys")
}
}
}
\seealso{
\code{\link[=add_predicted_draws]{add_predicted_draws()}}, \code{\link[=add_draws]{add_draws()}}
}
\author{
Matthew Kay
}
\keyword{manip}
