% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emmeans_comparison.R
\name{emmeans_comparison}
\alias{emmeans_comparison}
\title{Use emmeans contrast methods with compare_levels}
\usage{
emmeans_comparison(method, ...)
}
\arguments{
\item{method}{An emmeans-style contrast method. One of: (1) a string specifying
the name of an \link[emmeans:emmc-functions]{emmeans contrast method}, like
\code{"pairwise"}, \code{"trt.vs.ctrl"}, \code{"eff"}; or (2) an emmeans-style contrast
function itself, like \link[emmeans:emmc-functions]{emmeans::pairwise.emmc}, \link[emmeans:emmc-functions]{emmeans::trt.vs.ctrl.emmc}, etc,
or a custom function that takes a vector of factor levels and returns a
contrast matrix.}

\item{...}{Arguments passed on to the contrast method.}
}
\value{
A function that takes a single argument, \code{var}, containing a variable
to generate contrasts for (e.g., a factor or a character vector) and returns
a function that generates a list of named unevaluated expressions representing
different contrasts of that variable. This function is suitable to be used
as the \code{comparison} argument in \code{compare_levels()}.
}
\description{
Convert \link[emmeans:emmc-functions]{emmeans contrast methods} into comparison functions
suitable for use with \code{\link[=compare_levels]{compare_levels()}}.
}
\details{
Given an \link[emmeans:emmc-functions]{emmeans contrast method} name as a string
(e.g., \code{"pairwise"}, \code{"trt.vs.ctrl"}, etc) or an emmeans-style contrast function
(e.g., \link[emmeans:emmc-functions]{emmeans::pairwise.emmc}, \link[emmeans:emmc-functions]{emmeans::trt.vs.ctrl.emmc}, etc), \code{emmeans_comparison()}
returns a new function that can be used in the \code{comparison} argument to \code{compare_levels()}
to compute those contrasts.
}
\examples{
\dontshow{if (requireNamespace("emmeans", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

library(dplyr)
library(ggplot2)

data(RankCorr, package = "ggdist")

# emmeans contrast methods return matrices. E.g. the "eff" comparison
# compares each level to the average of all levels:
emmeans:::eff.emmc(c("a","b","c","d"))

# tidybayes::compare_levels() can't use a contrast matrix like this
# directly; it takes arbitrary expressions of factor levels. But
# we can use `emmeans_comparison` to generate the equivalent expressions:
emmeans_comparison("eff")(c("a","b","c","d"))

# We can use the "eff" comparison type with `compare_levels()` as follows:
RankCorr \%>\%
  spread_draws(b[i,j]) \%>\%
  filter(j == 1) \%>\%
  compare_levels(b, by = i, comparison = emmeans_comparison("eff")) \%>\%
  median_qi()
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=compare_levels]{compare_levels()}}, \link[emmeans:emmc-functions]{emmeans::contrast-methods}.
See \code{\link[=gather_emmeans_draws]{gather_emmeans_draws()}} for a different approach to using \code{emmeans} with
\code{tidybayes}.
}
\author{
Matthew Kay
}
